/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.directory.event.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import javax.naming.Name;

import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListener;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;

/**
 * @version $Revision: 1.3 $
 * @author $Author: johan $
 */
public class EventListenerRegistryImpl implements
		DirectoryEventListenerRegistry {

	private HashMap<ConnectionGUID, List<DirectoryEventListener>> connectionMap = new HashMap<ConnectionGUID, List<DirectoryEventListener>>();

	public EventListenerRegistryImpl() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.event.EventListenerRegistry#addEventListener(nu.zoom.ldap.eon.connection.ConnectionInformation,
	 *      nu.zoom.ldap.eon.directory.event.DirectoryEventListener)
	 */
	public synchronized void addEventListener(ConnectionGUID connection,
			DirectoryEventListener listener) {
		if (connection == null) {
			throw new IllegalArgumentException("Connection may not be null");
		}
		List<DirectoryEventListener> listeners = connectionMap.get(connection);
		if (listeners == null) {
			listeners = new ArrayList<DirectoryEventListener>();
			connectionMap.put(connection, listeners);
		}
		listeners.add(listener);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.event.EventListenerRegistry#removeEventListener(nu.zoom.ldap.eon.directory.event.DirectoryEventListener)
	 */
	public synchronized void removeEventListener(DirectoryEventListener listener) {
		Collection<List<DirectoryEventListener>> listenerRegistries = connectionMap
				.values();
		for (List registry : listenerRegistries) {
			registry.remove(listener);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.event.EventListenerRegistry#fireStructureChanged(nu.zoom.ldap.eon.connection.ConnectionInformation,
	 *      javax.naming.Name)
	 */
	public synchronized void fireStructureChanged(ConnectionGUID connection,
			final Name name) {
		List listeners = (List) connectionMap.get(connection);
		if (listeners != null) {
			for (int i = 0; i < listeners.size(); i++) {
				final DirectoryEventListener listener = (DirectoryEventListener) listeners
						.get(i);
				Thread listenerThread = new Thread(new Runnable() {

					public void run() {
						listener.structureChanged(name);
					}
				});
				listenerThread.setDaemon(true);
				listenerThread.start();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.event.EventListenerRegistry#fireAttributesChanged(nu.zoom.ldap.eon.connection.ConnectionInformation,
	 *      javax.naming.Name)
	 */
	public synchronized void fireAttributesChanged(ConnectionGUID connection,
			final Name name) {
		List listeners = (List) connectionMap.get(connection);
		if (listeners != null) {
			for (int i = 0; i < listeners.size(); i++) {
				final DirectoryEventListener listener = (DirectoryEventListener) listeners
						.get(i);
				Thread listenerThread = new Thread(new Runnable() {

					public void run() {
						listener.attributesChanged(name);
					}
				});
				listenerThread.setDaemon(true);
				listenerThread.start();
			}
		}
	}
}