/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.directory.event;

import javax.naming.Name;

import nu.zoom.ldap.eon.connection.ConnectionGUID;

/**
 * Tracks listeners of directory events.
 * 
 * @version $Revision: 1.1 $
 * @author $Author: johan $
 */
public interface DirectoryEventListenerRegistry
{

	public void addEventListener(
			ConnectionGUID connection,
			DirectoryEventListener listener);

	public void removeEventListener(DirectoryEventListener listener);

	/**
	 * Informes registered listeners about a structure change.
	 * 
	 * @see DirectoryEventListener#structureChanged(Name)
	 * @param connection
	 *            The directory where the change took place. May not be null.
	 * @param name
	 *            The object that is the root of the change. If the object is
	 *            created its parent should be used.May not be null.
	 */
	public void fireStructureChanged(ConnectionGUID connection, Name name);

	/**
	 * Inform registered listeners about a change in attributes on the named
	 * object.
	 * 
	 * @param connection
	 *            The directory where the change took place.May not be null.
	 * @param name
	 *            The object that had its attributes changed.May not be null.
	 */
	public void fireAttributesChanged(ConnectionGUID connection, Name name);
}
