/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.directory.event;

import javax.naming.Name;

/**
 * This is a listener that is used by GUI components to inform other components
 * about changes they have made to the directory. This is to allow components
 * that caches directory information (for example by showing it on the screen)
 * to keep the cache fresh.
 * 
 * @version $Revision: 1.1 $
 * @author $Author: johan $
 */
public interface DirectoryEventListener
{

	/**
	 * The directory tree struture has changed below the named element. If an
	 * element has been created the parent object should be used as a parameter.
	 * The call is not guaranteed to occur on the Swing event queue thread so
	 * listeners must take precaution not to directly modify GUI components.
	 * 
	 * @see java.awt.EventQueue
	 * @param name
	 *            The root above the change.
	 */
	public void structureChanged(Name name);

	/**
	 * Attributes have changed for the named object. The call is not guaranteed
	 * to occur on the Swing event queue thread so listeners must take
	 * precaution not to directly modify GUI components.
	 * 
	 * @see java.awt.EventQueue
	 * @param name
	 *            The object that has had its attributes modified.
	 */
	public void attributesChanged(Name name);
}
