/*
 * Copyright (C) 2004 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package nu.zoom.ldap.eon.directory.attributes;

import javax.naming.directory.Attribute;

/**
 * 
 * @author $Author: johan $
 * @version $Revision: 1.2 $
 */
public class AttributeTableRow implements Comparable<AttributeTableRow>
{

	private String value;
	private String id;
	private Attribute attribute;

	public Attribute getAttribute() {
		return attribute;
	}

	public String getId() {
		return id;
	}

	public String getValue() {
		return value;
	}

	public void setAttribute(Attribute attribute) {
		this.attribute = attribute;
	}

	public void setId(String string) {
		id = string;
	}

	public void setValue(String string) {
		value = string;
	}

	public boolean equals(Object obj) {
		if (obj instanceof AttributeTableRow) {
			return toString().equals(obj.toString());
		} else {
			return false;
		}
	}

	public String toString() {
		return id + "[" + value + "]";
	}

	public int compareTo(AttributeTableRow o) {
		return toString().compareTo(o.toString());
	}
}
