/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.attributes;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;

/**
 * @author $Author: johan $
 * @version $Revision: 1.3 $
 */
public class AttributeEditorFactoryImpl implements AttributeEditorFactory {

	private AttributeEditor stringEditor;

	public AttributeEditorFactoryImpl(AttributeEditor stringEditor) {
		super();
		this.stringEditor = stringEditor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.attributes.AttributeEditorFactory#getEditor(javax.naming.directory.Attribute)
	 */
	public AttributeEditor getEditor(Attribute attribute)
			throws NamingException {
		Object attrValue = attribute.get();
		if (attrValue instanceof String) {
			return stringEditor;
		} else {
			return null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.attributes.AttributeEditorFactory#getEditor(java.lang.String)
	 */
	public AttributeEditor getEditor(String attributeID) {
		return stringEditor;
	}
}
