/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.attributes;

import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.ldap.InitialLdapContext;

import nu.zoom.ldap.eon.connection.ConnectionInformation;

/**
 * Atribute editors implement this interface. The editor also needs to be
 * registered as an attribute editor contribution.
 * 
 * @author $Author: johan $
 * @version $Revision: 1.3 $
 */
public interface AttributeEditor
{

	/**
	 * The editor should should become visible and let the user edit the
	 * attribute value(s).
	 * 
	 * @param attribute
	 *            The attribute to edit.
	 * @param iCtx
	 *            The connection to the directory.
	 * @param name
	 *            The object in the directory that should be updated with the
	 *            new edited attribute.
	 * @param connectionInformation
	 *            The connection used to operate on the attribute.
	 */
	public void edit(
			ConnectionInformation connectionInformation,
			InitialLdapContext iCtx,
			Name name,
			Attribute attribute);

	/**
	 * The editor should become visible and let the user add a new attribute
	 * with value(s).
	 * 
	 * @param iCtx
	 *            The connection to the directory.
	 * @param name
	 *            The object that should have the new attribute.
	 * @param newAttributeID
	 *            The new attribute name that the editor should create.
	 * @param connectionInformation
	 *            The connection used to operate on the attribute.
	 */
	public void create(
			ConnectionInformation connectionInformation,
			InitialLdapContext iCtx,
			Name name,
			String newAttributeID);
}
