/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.attributes;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.layout.VerticalPanel;

import org.ops4j.gaderian.Messages;

/**
 * Dialog that allows the user to enter an attribute ID to add to an object.
 * 
 * @version $Revision: 1.4 $
 * @author $Author: johan $
 */
class AddAttributeDialog extends JDialog
{

	private String attributeID = null;
	private JTextField attributeIdField;
//	private Workbench workbench;
//	private Messages messages;

	AddAttributeDialog(Workbench workbench, Messages messages) {
		super(workbench.getDialogOwner(), messages
				.getMessage("attributes.dialog.add.title"), true);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

		attributeIdField = new JTextField(30);
		attributeIdField.setToolTipText(messages
				.getMessage("attributes.dialog.add.id.tooltip"));

		JLabel attributeIdLabel = new JLabel(messages
				.getMessage("attributes.dialog.add.id"));
//		JLabel bannerLabel = new JLabel(MessagesUtil.getIconFromMessages(
//				messages,
//				"dialog.banner"));

		JButton okButton = new JButton(messages
				.getMessage("attributes.dialog.add.ok"));
		okButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				String text = attributeIdField.getText();
				if ((text != null) && (text.trim().length() < 1)) {
					attributeID = null;
				} else {
					attributeID = text.trim();
				}
				dispose();
			}
		});
		JButton cancelButton = new JButton(messages
				.getMessage("attributes.dialog.add.cancel"));
		cancelButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				attributeID = null;
				dispose();
			}
		});

		JPanel buttonpanel = new JPanel(new FlowLayout());
		buttonpanel.add(okButton);
		buttonpanel.add(cancelButton);
		VerticalPanel panel = new VerticalPanel();
		panel.addRow(attributeIdLabel, attributeIdField);
		panel.addRow(buttonpanel);

		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(panel, BorderLayout.CENTER);
	}

	/**
	 * Get the attribute ID the user entered.
	 * 
	 * @return The entered attribute ID. Null if the text is only blank.
	 */
	public String getText() {
		return attributeID;
	}
}
