/*
 * Copyright (C) 2005,2009 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.desktop;

import java.awt.EventQueue;
import java.util.List;

import javax.naming.ldap.InitialLdapContext;
import javax.swing.JComponent;

import nu.zoom.ldap.eon.connection.ConnectionInformation;
import nu.zoom.ldap.eon.directory.attributes.AllAttributesComponent;
import nu.zoom.ldap.eon.directory.attributes.AttributeEditorFactory;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeAndAttributesComponent;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.preferences.Preferences;

import org.ops4j.gaderian.Messages;

public class ComponentFactoryImpl implements ComponentFactory {

    private Workbench workbench;
    private Messages messages;
    private OperationManager operationManager;
    private Preferences preferences;
    private AttributeEditorFactory attributeEditorFactory;
    private DirectoryEventListenerRegistry eventRegistry;
    private List<DirectoryTreePopUpItem> popupItems;

    public ComponentFactoryImpl(Workbench workbench, Messages messages,
            OperationManager operationManager, Preferences preferences,
            AttributeEditorFactory attributeEditorFactory,
            DirectoryEventListenerRegistry eventRegistry,
            List<DirectoryTreePopUpItem> popupItems) {
        super();
        this.workbench = workbench;
        this.messages = messages;
        this.operationManager = operationManager;
        this.preferences = preferences;
        this.attributeEditorFactory = attributeEditorFactory;
        this.eventRegistry = eventRegistry;
        this.popupItems = popupItems;
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.ldap.eon.desktop.ComponentFactory#getNewConnectionComponent(javax.naming.ldap.InitialLdapContext,
     *      java.lang.String, nu.zoom.ldap.eon.connection.ConnectionGUID)
     */
    @Override
    public void showNewConnection(final InitialLdapContext iCtx,
            final ConnectionInformation connectionInformation) {
        EventQueue.invokeLater(new Runnable() {

            @Override
            public void run() {
                DirectoryTree tree = new DirectoryTree(operationManager,
                        workbench, messages, iCtx, connectionInformation,
                        popupItems);
                eventRegistry.addEventListener(connectionInformation.getGUID(),
                        tree);

                AllAttributesComponent attrs = new AllAttributesComponent(
                        workbench, messages, attributeEditorFactory, iCtx,
                        connectionInformation);
                eventRegistry.addEventListener(connectionInformation.getGUID(),
                        attrs);

                DirectoryTreeAndAttributesComponent comp = new DirectoryTreeAndAttributesComponent(
                        tree, attrs, operationManager, workbench, messages,
                        preferences, connectionInformation.getGUID());

                WorkbenchFrame frame = workbench.createWorkbenchFrame(
                        "nu.zoom.eon2.connection.frame." + connectionInformation.getGUID(), comp, true,
                        true);
                frame.setTitle(connectionInformation.getDescription());
                frame.addFrameListener(comp);
                frame.setVisible(true);
                // Swing splitpane dividers can not be positioned until _after_
                // the component is visible
                comp.setDividerLocation();
            }
        });
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.ldap.eon.desktop.ComponentFactory#getAllAttributesComponent()
     */
    @Override
    public JComponent getAllAttributesComponent(InitialLdapContext iCtx,
            ConnectionInformation connectionInformation) {
        return new AllAttributesComponent(workbench, messages,
                attributeEditorFactory, iCtx, connectionInformation);
    }
}
