/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.desktop;

import javax.naming.ldap.InitialLdapContext;
import javax.swing.JComponent;

import nu.zoom.ldap.eon.connection.ConnectionInformation;

/**
 * Factory that produces EON components (those that are not plug-ins). All
 * methods can be called from any thread (does not have to be the AWT dispatch
 * thread).
 * 
 * @version $Revision: 1.7 $
 * @author $Author: johan $
 */
public interface ComponentFactory
{

	/**
	 * Displays the 'start' component when a new connection is made. This method
	 * is thread safe and may be called from any thread.
	 * 
	 * @param iCtx
	 *            The connection that was opened.
	 * @param connectionInformation
	 *            A description of the connection so that the user can identifiy
	 *            which connection this is.
	 */
	public void showNewConnection(
			InitialLdapContext iCtx,
			ConnectionInformation connectionInformation);

	public JComponent getAllAttributesComponent(
			InitialLdapContext iCtx,
			ConnectionInformation connectionInformation);
}
