/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection.password;

import java.util.Hashtable;

import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;

import nu.zoom.swing.desktop.common.BackendException;

/**
 * @author $Author: johan $
 * @version $Revision: 1.4 $
 */
public class UserPasswordConnection extends UserConnection {
	static final long serialVersionUID = 1533056771518970139L;

	private char[] password;

	public UserPasswordConnection() {
		super();
	}

	/**
	 * @return Returns the password.
	 */
	public char[] getPassword() {
		return password;
	}

	/**
	 * @param password
	 *            The password to set.
	 */
	public void setPassword(char[] password) {
		this.password = password;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.connection.Connection#getConnection()
	 */
	public synchronized InitialLdapContext getConnection()
			throws BackendException {
		Hashtable env = new Hashtable();
		setupEnvironment(env, getUsername(), getPassword());
		try {
			InitialLdapContext iCtx = new InitialLdapContext(env, null);
			return iCtx;
		} catch (NamingException e) {
			throw new BackendException(e);
		}
	}
}
