/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection.password;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.layout.VerticalPanel;

import org.ops4j.gaderian.Messages;

/**
 * @author $Author: johan $
 * @version $Revision: 1.2 $
 */
public class PasswordDialog extends JDialog
{

	private JPasswordField passwordField;
	private boolean closeOK = false;

	public PasswordDialog(Workbench workbench, Messages messages) {
		super(workbench.getDialogOwner(), messages
				.getMessage("connection.password.query.title"), true);
		passwordField = new JPasswordField(40);
		JLabel passwordLabel = new JLabel(messages
				.getMessage("connection.password.query"));
		JButton okButton = new JButton(messages
				.getMessage("connection.password.connect"));
		
		okButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				setCloseOK(true);
				dispose();
			}
		});
		JButton cancelButton = new JButton(messages
				.getMessage("connection.password.cancel"));
		cancelButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				setCloseOK(false);
				dispose();
			}
		});

		passwordField.addKeyListener(new KeyAdapter() {

			public void keyReleased(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_ENTER) {
					e.consume();
					setCloseOK(true);
					dispose();
				}
				super.keyTyped(e);
			}
		});

		JPanel buttonPanel = new JPanel();
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);

		VerticalPanel panel = new VerticalPanel();
		panel.addRow(passwordLabel, passwordField);
		panel.addRow(buttonPanel);

		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(panel, BorderLayout.CENTER);

		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		pack();
		setLocationRelativeTo(workbench.getDialogOwner());
	}

	/**
	 * Indicates if the user selected the OK (connect) button.
	 * 
	 * @return Returns true if user selected OK, false if cancel.
	 */
	boolean isCloseOK() {
		return closeOK;
	}

	void setCloseOK(boolean closeOK) {
		this.closeOK = closeOK;
	}

	public char[] getPassword() {
		return passwordField.getPassword();
	}
}
