/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection.password;

import java.io.Serializable;
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;

import nu.zoom.ldap.eon.connection.Connection;
import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.swing.desktop.common.BackendException;

/**
 * @author $Author: johan $
 * @version $Revision: 1.5 $
 */
public class AnonymousConnection implements Connection, Serializable {

    static final long serialVersionUID = 1746373875944572437L;
    private ConnectionGUID id;
    private String host = null;
    private int port = -1;
    private String description;
    private String rootContext = null;

    public AnonymousConnection() {
        super();
        id = ConnectionGUID.getInstance();
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.ldap.eon.connection.Connection#getGUID()
     */
    public ConnectionGUID getGUID() {
        return id;
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.ldap.eon.connection.Connection#getConnection()
     */
    public InitialLdapContext getConnection() throws BackendException {
        Hashtable env = new Hashtable();
        setupEnvironment(env);
        try {
            InitialLdapContext iCtx = new InitialLdapContext(env, null);
            return iCtx;
        } catch (NamingException e) {
            throw new BackendException(e);
        }
    }

    @SuppressWarnings("unchecked")
    protected void setupEnvironment(Hashtable env) {
        env.put(Context.INITIAL_CONTEXT_FACTORY,
                "com.sun.jndi.ldap.LdapCtxFactory");

        StringBuffer ldapURL = new StringBuffer();
        ldapURL.append("ldap://");
        ldapURL.append(host);
        ldapURL.append(":");
        ldapURL.append(port);
        if (getRootContext() != null) {
            ldapURL.append("/");
            ldapURL.append(rootContext);
        }

        env.put(Context.PROVIDER_URL, ldapURL.toString());
        env.put(Context.REFERRAL, "follow");
        /*
        env.put("java.naming.ldap.derefAliases", "never");
        */
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setGUID(ConnectionGUID id) {
        this.id = id;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRootContext() {
        return rootContext;
    }

    public void setRootContext(String rootContext) {
        this.rootContext = rootContext;
    }
}
