/*
 *  Copyright 2009 joma7188.
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  under the License.
 */
package nu.zoom.ldap.eon.connection.dns;

import javax.swing.JCheckBoxMenuItem;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.common.action.ToggleFrameAction;
import nu.zoom.util.dns.Resolver;
import org.ops4j.gaderian.Messages;

/**
 *
 * @author Johan Maasing
 */
public class FindServersMenuItem extends ToggleFrameAction<JCheckBoxMenuItem> {

    private final Workbench workbench;
    private final OperationManager operationManager;
    private final Resolver resolver;
    private final Messages messages;

    public FindServersMenuItem(final Messages messages, final Workbench workbench, final OperationManager operationManager, final Resolver resolver) {
        super(new JCheckBoxMenuItem());
        this.workbench = workbench;
        this.operationManager = operationManager;
        this.resolver = resolver;
        this.messages = messages;
        setName(messages.getMessage("connection.dns.menu"));
    }

    @Override
    protected WorkbenchFrame createFrame() {
        WorkbenchFrame frame = workbench.createWorkbenchFrame(
                "findadservers",
                new FindServersPanel(messages, operationManager, workbench, resolver),
                enabled,
                enabled);
        frame.setTitle(messages.getMessage("connection.dns.menu"));
        return frame;
    }

    @Override
    public void frameDetached(WorkbenchFrame frame) {
    }

    @Override
    public void frameAttached(WorkbenchFrame frame) {
    }
}
