/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection;

import java.awt.event.ActionEvent;

import javax.swing.JComponent;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.common.action.WorkbenchMessageAction;

import org.ops4j.gaderian.Messages;

/**
 * @author $Author: johan $
 * @version $Revision: 1.7 $
 */
public class EditConnectionAction extends WorkbenchMessageAction {
	private Connection connection;

	protected ConnectionFactory connectionFactory;

	protected Workbench workbench;

	/**
	 * Action that instructs a connection factory to edit a connection.
	 * 
	 * @param messages
	 * @param connectionFactory
	 */
	public EditConnectionAction(Workbench workbench, Messages messages,
			ConnectionFactory connectionFactory, Connection connection) {
		super(messages);
		this.connection = connection;
		this.connectionFactory = connectionFactory;
		this.workbench = workbench;
		setIconFromMessages("connection.menu.edit.icon");
		setNameFromMessages("connection.menu.edit");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		ConnectionEditor editor = connectionFactory.getEditor();
		if (editor == null) {
			workbench.getErrorReporter().reportError(
					messages.getMessage("connection.error.noeditor"));
		} else {
			JComponent editorComponent = editor.editConnection(connection);
			if (editorComponent == null) {
				workbench.getErrorReporter().reportError(
						messages.getMessage("connection.error.noeditor"));
			} else {
				WorkbenchFrame frame = workbench.createWorkbenchFrame(this
						.getClass().getName(), editorComponent, true, true);
				frame.setTitle(messages.getMessage("connection.edit.title"));
				frame.setVisible(true);
			}
		}
	}

}
