package nu.zoom.ldap.eon.connection;

import java.awt.event.ActionEvent;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.common.action.WorkbenchMessageAction;

import org.ops4j.gaderian.Messages;

public class DeleteConnectionAction extends WorkbenchMessageAction {
	private Workbench workbench;

	private ConnectionFactory connectionFactory;

	private Connection connection;

	public DeleteConnectionAction(Messages messages, Workbench workbench,
			ConnectionFactory connectionFactory, Connection connection) {
		super(messages);
		this.workbench = workbench;
		this.connectionFactory = connectionFactory;
		this.connection = connection;
		setNameFromMessages("connection.delete");
		setIconFromMessages("connection.delete.icon");
	}

	public void actionPerformed(ActionEvent e) {
		try {
			connectionFactory.removeConnection(connection);
			workbench.setStatusbarMessage(messages.format("connection.deleted",
					connection.getDescription()));
		} catch (BackendException exc) {
			workbench.getErrorReporter().reportError(
					messages.format("connection.error.backend", exc
							.getLocalizedMessage()));
		}
	}

}
