/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.common.action.WorkbenchMessageAction;

import org.ops4j.gaderian.Messages;

/**
 * @author $Author: johan $
 * @version $Revision: 1.6 $
 */
public class CreateConnectionAction extends WorkbenchMessageAction {
	private ImageIcon icon;

	protected ConnectionFactory connectionFactory;

	protected Workbench workbench;

	/**
	 * @param messages
	 */
	public CreateConnectionAction(Workbench workbench, Messages messages,
			ConnectionFactory connectionFactory, ImageIcon icon) {
		super(messages);
		this.connectionFactory = connectionFactory;
		this.workbench = workbench;
		this.icon = icon;
		this.connectionFactory = connectionFactory;
		this.workbench = workbench;
		setNameFromMessages("connection.menu.add");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		ConnectionEditor editor = connectionFactory.getEditor();
		if (editor == null) {
			workbench.getErrorReporter().reportError(
					messages.getMessage("connection.error.noeditor"));
		} else {
			JComponent editorComponent = editor.createNewConnectionEditor();
			if (editorComponent == null) {
				workbench.getErrorReporter().reportError(
						messages.getMessage("connection.error.noeditor"));
			} else {
				WorkbenchFrame frame = workbench.createWorkbenchFrame(this
						.getClass().getName(), editorComponent, true, true);
				frame.setTitle(messages.getMessage("connection.add.title"));
				if (icon != null) {
					frame.setFrameIcon(icon);
				}
				editor.setOwnerFrame(frame);
				frame.setVisible(true);
			}
		}
	}
}
