/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection;

import java.util.List;

import javax.swing.JMenu;

import nu.zoom.ldap.eon.connection.dns.FindServersMenuItem;
import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.PlugIn;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchListener;

import nu.zoom.util.dns.Resolver;
import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.7 $
 * @author $Author: johan $
 */
public class ConnectionPlugIn implements PlugIn, WorkbenchListener {

    private JMenu connectionsMenu = null;
    private final Workbench workbench;
    private final Messages messages;
    private final List<ConnectionFactory> connectionFactories;
    private final OperationManager operationManager;
    private final ComponentFactory componentFactory;
    private final Resolver resolver;

    public ConnectionPlugIn(Workbench workbench, Messages messages,
            OperationManager operationManager,
            ComponentFactory componentFactory,
            List<ConnectionFactory> factories,
            final Resolver resolver) {
        this.workbench = workbench;
        this.messages = messages;
        this.operationManager = operationManager;
        this.componentFactory = componentFactory;
        this.connectionFactories = factories;
        this.resolver = resolver;
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.swing.desktop.PlugIn#initialize()
     */
    @SuppressWarnings("unchecked")
    @Override
    public void initialize() throws Exception {
        workbench.addWorkBenchListener(this);
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.swing.desktop.WorkbenchListener#start()
     */
    @Override
    public void start() {
        if (connectionsMenu == null) {
            connectionsMenu = new JMenu(messages.getMessage("connection.menu"));
            connectionsMenu.add(new FindServersMenuItem(messages, workbench, operationManager, resolver));
            if (connectionFactories.size() > 0) {
                for (ConnectionFactory factory : connectionFactories) {
                    ConnectionMenuChangeHandler menuHandler = new ConnectionMenuChangeHandler(
                            workbench, messages, componentFactory,
                            operationManager, factory);
                    connectionsMenu.add(menuHandler.getMenu());
                }
            }
        }
        workbench.getMenuBar().addMenu("connectionsmenu", connectionsMenu);
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.swing.desktop.WorkbenchListener#close()
     */
    @Override
    public void close() {
    }
}
