/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection;

/**
 * ConnectionFactory events.
 * 
 * @version $Revision: 1.2 $
 * @author $Author: johan $
 */
public interface ConnectionFactoryListener
{

	/**
	 * A new connection was created.
	 * 
	 * @param connection
	 *            The connection that was created.
	 */
	public void createdConnection(Connection connection);

	/**
	 * A connection has been removed.
	 * 
	 * @param connectionGUID
	 *            The ID of the connection that was removed.
	 */
	public void removedConnection(ConnectionGUID connectionGUID);

	/**
	 * The data for a connection has changed.
	 * 
	 * @param connection
	 *            The connection where the data has changed.
	 */
	public void connectionDataChanged(Connection connection);
}
