/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.connection;

import javax.swing.ImageIcon;

import nu.zoom.swing.desktop.common.BackendException;

/**
 * @version $Revision: 1.2 $
 * @author $Author: johan $
 */
public interface ConnectionFactory
{

	/**
	 * Add a listener for changes in the connection collection. Implementation
	 * classes should notify listeners when connections changes.
	 * 
	 * @param listener
	 *            The listener.
	 */
	public void addConnectionFactoryListener(ConnectionFactoryListener listener);

	/**
	 * Remove a previously registered listener.
	 * 
	 * @param listener
	 *            The listener to remove.
	 */
	public void removeConnectionFactoryListener(
			ConnectionFactoryListener listener);

	/**
	 * Get all connections this factory handles.
	 * 
	 * @return An array of collections.
	 * @throws BackendException
	 */
	public Connection[] listConnections() throws BackendException;

	/**
	 * Delete a connection.
	 * 
	 * @param connection
	 *            The connection to delete.
	 * @throws BackendException
	 */
	public void removeConnection(Connection connection) throws BackendException;

	/**
	 * Get a description of the type of connections this factory handles. THe
	 * description should be suitable for use as a tooltip.
	 * 
	 * @return A descrioption of the connections this factory provides.
	 */
	public String getDescription();

	/**
	 * The connection factory should provide a short name for the type of
	 * connections the factory handles. This should be suitable for use as an
	 * item on a menu.
	 * 
	 * @return The name for the connection factory.
	 */
	public String getName();

	/**
	 * The factory can provide an icon to represent the connection type it
	 * handles.
	 * 
	 * @return The icon to use. Null if hte factory does not have an icon.
	 */
	public ImageIcon getIcon();

	/**
	 * The factory should provide an editor for the type of connections the
	 * factory handles.
	 * 
	 * @return An editor.
	 */
	public ConnectionEditor getEditor();

}
