/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.connection;

import javax.swing.JComponent;

import nu.zoom.swing.desktop.WorkbenchFrame;

/**
 * An editor for connections.
 * 
 * @version $Revision: 1.2 $
 * @author $Author: johan $
 */
public interface ConnectionEditor {

	/**
	 * The editor should create a new connection and let the user edit the newly
	 * created connection. The editor is responsible for persisting the
	 * connection when the user is done. The editor factory that provided the
	 * editor should let their listeners know when the connection data changes.
	 * 
	 * @return An editor component that can create new connections.
	 */
	public JComponent createNewConnectionEditor();

	/**
	 * Create an editor for the given connection. If the editor does not know
	 * how to edit the given connection it should return null. The editor is
	 * responsonsible for making the connection persistant when the user is done
	 * editing. The editor factory that provided the editor should let their
	 * listeners know when the connection data changes.
	 * 
	 * @param connection
	 *            The connection that the user elected to edit.
	 * @return An editor component for the given connection.
	 */
	public JComponent editConnection(Connection connection);

	/**
	 * When the framework has wrapped the editor in a frame the frame will be
	 * handed to the editor so that the ditor can operate on the frame.
	 * 
	 * @param frame
	 *            The frame that embeds the editor.
	 */
	public void setOwnerFrame(WorkbenchFrame frame);
}
