/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection;

import java.awt.EventQueue;

import javax.naming.ldap.InitialLdapContext;

import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;

import org.ops4j.gaderian.Messages;

/**
 * Operation to connect to a directory. Instantiate this class then pass it to
 * the operation manager.
 * 
 * @see nu.zoom.ldap.eon.operation.OperationManager#runOperation(Operation)
 * @author $Author$
 * @version $Revision$
 * 
 */
public class ConnectOperation implements Operation {

    private Workbench workbench;
    private Messages messages;
    private Connection connection;
    private ComponentFactory componentFactory;

    /**
     * Create a new connection operation.
     *
     * @param workbench
     * @param messages
     * @param connection
     * @param componentFactory
     */
    public ConnectOperation(Workbench workbench, Messages messages,
            Connection connection, ComponentFactory componentFactory) {
        this.workbench = workbench;
        this.messages = messages;
        this.connection = connection;
        this.componentFactory = componentFactory;
    }

    /**
     * Do not call this method directly. This method is called by the operation
     * manager.
     *
     * @see nu.zoom.ldap.eon.operation.OperationManager#runOperation(Operation)
     *
     */
    public void execute() {
        try {
            workbench.startWorkIndicator();
            workbench.setStatusbarMessage(messages.format(
                    "connection.connecting", connection.getDescription()));
            final InitialLdapContext iCtx = connection.getConnection();
            if (iCtx != null) {
                EventQueue.invokeLater(new Runnable() {

                    public void run() {
                        workbench.stopWorkIndicator();
                        componentFactory.showNewConnection(iCtx, connection);

                    }
                });
            }
        } catch (BackendException e) {
            workbench.stopWorkIndicator();
            workbench.getErrorReporter().reportError(
                    messages.format("connection.connect.error", connection.getDescription()), e);
        }
    }
}
