/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.connection;

import java.awt.event.ActionEvent;

import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.action.WorkbenchMessageAction;

import org.ops4j.gaderian.Messages;

/**
 * @author $Author: johan $
 * @version $Revision: 1.12 $
 */
public class ConnectAction extends WorkbenchMessageAction {
	private ConnectOperation operation;

	private OperationManager operationManager;

	public ConnectAction(Workbench workbench, Messages messages,
			Connection connection, ComponentFactory componentFactory,
			OperationManager operationManager) {
		super(messages);
		setNameFromMessages("connection.menu.connect");
		setIconFromMessages("connection.menu.connect.icon");
		operation = new ConnectOperation(workbench, messages, connection,
				componentFactory);
		this.operationManager = operationManager;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */

	public void actionPerformed(ActionEvent e) {
		operationManager.runOperation(operation);
	}

}
