/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.clipboard.impl;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

import nu.zoom.ldap.eon.clipboard.DirectoryClipboardItem;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.util.UniqueIDGenerator;

import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.9 $
 * @author $Author: johan $
 */
public class DirectoryObjectCopyClipboardItem implements
		DirectoryClipboardItem, ClipboardAction
{

	private static UniqueIDGenerator idGenerator = new UniqueIDGenerator();

	private String id;
	private String description;
	private Messages messages;
	private Workbench workbench;
	private DirectoryTreeObject sourceObject;
	private DirectoryEventListenerRegistry eventRegistry;

	public DirectoryObjectCopyClipboardItem(DirectoryTreeObject sourceObject,
			Messages messages, Workbench workbench,
			DirectoryEventListenerRegistry eventRegistry) {
		super();
		this.messages = messages;
		this.workbench = workbench;
		this.sourceObject = sourceObject;
		this.eventRegistry = eventRegistry;
		id = idGenerator.getID();
		description = messages.format("clipboard.object.copy", sourceObject
				.getConnectionInformation().getDescription(), sourceObject
				.getDistinguishedName().toString());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.clipboard.DirectoryClipboardItem#getID()
	 */
	public String getID() {
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.clipboard.DirectoryClipboardItem#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.clipboard.impl.ClipboardAction#execute(javax.naming.ldap.InitialLdapContext,
	 *      javax.naming.Name)
	 */
	public void execute(DirectoryTreeObject target) throws BackendException {
		try {
			workbench.startWorkIndicator();
			Attributes attributes = sourceObject.getConnection().getAttributes(
					sourceObject.getDistinguishedName());
			Name sourceName = sourceObject.getDistinguishedName();
			Name sourceRDN = sourceName.getSuffix(sourceName.size() - 1);
			Name newName = ((Name) target.getDistinguishedName().clone())
					.addAll(sourceRDN);
			workbench.setStatusbarMessage(messages.format(
					"clipboard.object.cut",
					sourceObject.getDistinguishedName(),
					newName.toString()));
			target.getConnection().createSubcontext(newName, attributes);
			eventRegistry.fireStructureChanged(target.getTree()
					.getConnectionInformation().getGUID(), newName);
			workbench.stopWorkIndicator();
		} catch (NamingException e) {
			workbench.stopWorkIndicator();
			workbench.getErrorReporter().reportError(
					messages.getMessage("error.tree.copy"),
					e);
		}
	}
}
