/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.clipboard;

import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.swing.desktop.common.BackendException;

/**
 * Queue of items that have been marked for copy or cut.
 * 
 * @version $Revision: 1.6 $
 * @author $Author: johan $
 */
public interface DirectoryClipboard {

	/**
	 * Add a listener for changes to the clipboard.
	 * 
	 * @param listener
	 *            The listener to add.
	 */
	public void addDirectoyClipboardListener(DirectoryClipboardListener listener);

	/**
	 * Remove a preciously registered listener.
	 * 
	 * @param listener
	 */
	public void removeDirectoyClipboardListener(
			DirectoryClipboardListener listener);

	/**
	 * Add a Name (typically from a selected DirectoryTree node) to the queue.
	 * 
	 * @param sourceObject
	 *            The node marked for cut (move).
	 */
	public void addCut(DirectoryTreeObject sourceObject);

	/**
	 * Add a Name (typically from a selected DirectoryTree node) to the queue.
	 * 
	 * @param sourceObject
	 *            The node marked for copy.
	 */
	public void addCopy(DirectoryTreeObject sourceObject);

	/**
	 * Trigger the next item on the queue with the given target.
	 * 
	 * @param targetObject
	 *            The node that was marked as the paste target.
	 * @throws BackendException
	 */
	public void triggerPasteAction(DirectoryTreeObject targetObject)
			throws BackendException;

	/**
	 * Remove an item from the clipboard.
	 * 
	 * @param id
	 *            The id of the item, may not be null. If the item is no longer
	 *            in the clipboard this method does nothing.
	 */
	public void removeClipboardItem(String id);
}
