/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.about;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ImageIcon;

import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import nu.zoom.ldap.eon.desktop.BasicPlugIn;
import nu.zoom.ldap.eon.util.MessagesUtil;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.common.action.ToggleFrameAction;
import nu.zoom.swing.desktop.plugin.browser.Browser;
import nu.zoom.swing.layout.VerticalPanel;
import org.ops4j.gaderian.Messages;

public class About extends BasicPlugIn {

    private Browser browser;

    public About(Workbench workbench, Messages messages, Browser browser) {
        super(workbench, messages);
        this.browser = browser;
    }

    @Override
    public void start() {
        super.start();
        JMenuItem aboutMenuItem = new JMenuItem();
        AboutAction aboutAction = new AboutAction(messages, aboutMenuItem);
        aboutAction.setName(messages.getMessage("about.menuitem"));
        workbench.getMenuBar().addToHelpMenu(aboutMenuItem);
    }

    public class AboutAction extends ToggleFrameAction<JMenuItem> {

        public AboutAction(Messages messages, JMenuItem button) {
            super(button);
            String resourceName = messages.getMessage("about.menuitem.icon");
            URL url = getClass().getResource(resourceName);
            ImageIcon icon = null;
            if (url != null) {
                icon = new ImageIcon(url);
                if (icon != null) {
                    setIcon(icon);
                }
            }
        }

        @Override
        protected WorkbenchFrame createFrame() {
            workbench.setStatusbarMessage(messages.getMessage("about.copyright"));
            VerticalPanel copyPanel = new VerticalPanel();
            copyPanel.addRow(new JLabel(messages.getMessage("about.copyright")));
            copyPanel.addRow(new JLabel(messages.getMessage("about.license")));
            VerticalPanel mainPanel = new VerticalPanel();
            mainPanel.addRow(new JLabel(MessagesUtil.getIconFromMessages(
                    messages, "about.banner")), copyPanel);

            try {
                InputStream ins = About.class.getResourceAsStream(messages.getMessage("about.html"));
                InputStreamReader inr = new InputStreamReader(ins, "ISO-8859-1");
                StringBuilder aboutBuffer = new StringBuilder();
                char[] readBuffer = new char[1024];
                int numread = inr.read(readBuffer);
                while (numread > 0) {
                    aboutBuffer.append(readBuffer, 0, numread);
                    numread = inr.read(readBuffer);
                }
                String text = aboutBuffer.toString();
                JEditorPane aboutPane = new JEditorPane("text/html", text);
                aboutPane.setEditable(false);
                aboutPane.addHyperlinkListener(new Hyperactive());
                mainPanel.addRow(aboutPane);
            } catch (IOException e) {
                mainPanel.addRow(new JTextArea(e.toString()));
            }

            mainPanel.validate();
            WorkbenchFrame frame = workbench.createWorkbenchFrame(this.getClass().getName(), mainPanel, true, true);
            frame.setTitle(messages.getMessage("about.menuitem"));
            frame.setFrameIcon(MessagesUtil.getIconFromMessages(messages,
                    "about.menuitem.icon"));
            return frame;
        }

        @Override
        public void frameDetached(WorkbenchFrame frame) {
        }

        @Override
        public void frameAttached(WorkbenchFrame frame) {
        }
    }

    class Hyperactive implements HyperlinkListener {

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                browser.open(e.getURL());
            }
        }
    }
}
