/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

import javax.swing.JOptionPane;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchListener;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.Registry;
import org.ops4j.gaderian.impl.RegistryBuilder;


/**
 * @version $Revision: 1.4 $
 * @author $Author: johan $
 */
public class EyeOfNewt implements WorkbenchListener {

    private Workbench workbench;

    /**
     *
     */
    public EyeOfNewt() {
    }

    public static void main(String[] args) {
        EyeOfNewt eon = new EyeOfNewt();
        eon.run();
    }

    private void run() {
        JFrame splashFrame = new JFrame("EON");
        splashFrame.setUndecorated(true);
        URL url = EyeOfNewt.class.getResource("/nu/zoom/ldap/eon/images/EON-Splash-1.jpg");
        ImageIcon icon = new ImageIcon(url);
        icon = new ImageIcon(url);
        splashFrame.getContentPane().add(new JLabel(icon));
        splashFrame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        splashFrame.setLocation(
                screenSize.width / 2 - splashFrame.getWidth() / 2,
                screenSize.height / 2 - splashFrame.getHeight() / 2);
        splashFrame.setVisible(true);
        try {
            Registry registry = RegistryBuilder.constructDefaultRegistry();
            workbench = (Workbench) registry.getService(
                    "nu.zoom.swing.desktop.Workbench", Workbench.class);
            workbench.addWorkBenchListener(this);
            workbench.start();
        } catch (ApplicationRuntimeException exc) {
            exc.printStackTrace();
            JOptionPane.showMessageDialog(
                    splashFrame,
                    "Fatal error, unable to start application, terribly sorry about that.\n" +
                    exc.getLocalizedMessage(),
                    "ERROR",
                    JOptionPane.ERROR_MESSAGE);
        } finally {
            splashFrame.dispose();
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.swing.desktop.WorkbenchListener#close()
     */
    @Override
    public void close() {
    }

    /*
     * (non-Javadoc)
     *
     * @see nu.zoom.swing.desktop.WorkbenchListener#start()
     */
    @Override
    public void start() {
        workbench.setTitle("Eye Of Newt 2: Toe Of Toad \u00a9 2005 Johan Maasing");
        URL url = EyeOfNewt.class.getResource("/nu/zoom/ldap/eon/images/eye-icon.png");
        ImageIcon icon = new ImageIcon(url);
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        icons.add(icon);
        workbench.setIcon(icons);
    }
}
