/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.util.dns;

public class SRVRecord
implements Comparable<SRVRecord> {
    private final String hostname;
    private final int port;
    private final int priority;
    private final int weight;

    public SRVRecord(String hostname, int port, int priority, int weight) {
        if (hostname == null) {
            throw new IllegalArgumentException("Hostname may not be null");
        }
        this.hostname = hostname;
        this.priority = priority;
        this.weight = weight;
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRVRecord other = (SRVRecord)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return this.weight == other.weight;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.hostname != null ? this.hostname.hashCode() : 0);
        hash = 59 * hash + this.port;
        hash = 59 * hash + this.priority;
        hash = 59 * hash + this.weight;
        return hash;
    }

    public String toString() {
        return this.hostname + ":" + this.port + " w:" + this.weight + " p:" + this.priority;
    }

    @Override
    public int compareTo(SRVRecord other) {
        String s = this.hostname + " " + this.port + " " + this.priority + " " + this.weight;
        String o = other.hostname + " " + other.port + " " + other.priority + " " + other.weight;
        return s.compareTo(o);
    }
}

