/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.field;

import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FloatField
extends JTextField {
    protected DecimalFormat formatter;

    public FloatField() {
        super(11);
        this.setDocument(new TexCoordDocument());
        this.formatter = new DecimalFormat();
        this.formatter.setMaximumFractionDigits(6);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumIntegerDigits(6);
        this.formatter.setDecimalSeparatorAlwaysShown(true);
        this.formatter.setGroupingUsed(false);
        this.setValue(0.0f);
    }

    public FloatField(float value) {
        super(11);
        this.setDocument(new TexCoordDocument());
        this.formatter = new DecimalFormat();
        this.formatter.setMaximumFractionDigits(6);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumIntegerDigits(6);
        this.formatter.setDecimalSeparatorAlwaysShown(true);
        this.formatter.setGroupingUsed(false);
        this.setValue(value);
    }

    public FloatField(float value, boolean enabled) {
        super(11);
        this.setDocument(new TexCoordDocument());
        this.formatter = new DecimalFormat();
        this.formatter.setMaximumFractionDigits(6);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumIntegerDigits(6);
        this.formatter.setDecimalSeparatorAlwaysShown(true);
        this.formatter.setGroupingUsed(false);
        this.setValue(value);
        this.setEnabled(enabled);
    }

    public float getValue() throws ParseException {
        Number ret = this.formatter.parse(this.getText());
        return ret.floatValue();
    }

    public void setValue(float value) {
        String t = this.formatter.format(value);
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, t, null);
        }
        catch (BadLocationException e) {
            this.getToolkit().beep();
        }
    }

    public DecimalFormat getFormat() {
        return this.formatter;
    }

    public void setFormat(DecimalFormat format) {
        this.formatter = format;
    }

    class TexCoordDocument
    extends PlainDocument {
        ParsePosition ppos = new ParsePosition(0);

        TexCoordDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str == "") {
                int len = this.getLength();
                try {
                    this.remove(0, len);
                }
                catch (Exception exc) {
                    System.err.println(exc.toString());
                }
                return;
            }
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(offs, currentText.length());
            String proposedResult = beforeOffset + str + afterOffset;
            this.ppos.setIndex(0);
            FloatField.this.formatter.parseObject(proposedResult, this.ppos);
            if (this.ppos.getIndex() == proposedResult.length()) {
                super.insertString(offs, str, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(len + offs, currentText.length());
            String proposedResult = beforeOffset + afterOffset;
            if (proposedResult.length() == 0) {
                super.remove(offs, len);
            } else {
                this.ppos.setIndex(0);
                FloatField.this.formatter.parseObject(proposedResult, this.ppos);
                if (this.ppos.getIndex() == proposedResult.length()) {
                    super.remove(offs, len);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

