/*
 * Copyright (C) 2004, 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.dialog;

import javax.swing.*;

import nu.zoom.swing.layout.VerticalPanel;

import java.awt.*;

/**
 * Displays some standard system properties. This class pops-up a dialog that
 * display some standard system properties like java version. You can use it
 * like this: <br />
 * <code>SystemPropertiesDialog sd = new SystemPropertiesDialog() ;</code>
 * <br />
  * <code>sd.setVisible(true) ;</code><br />
 * 
 * @author $Author: johan $
 * @version $Revision: 1.3 $
 */
@SuppressWarnings("serial")
public class SystemPropertiesDialog extends JDialog {

	/**
	 * Initialize the dialog.
	 */
	public SystemPropertiesDialog() {
		super();
		init();
		pack();
	}

	private void init() {
		setTitle("System properties");
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				dispose();
			}
		});

		getContentPane().setLayout(new java.awt.BorderLayout());
		VerticalPanel mainPanel = new VerticalPanel();
		getContentPane().add(new JScrollPane(mainPanel), BorderLayout.CENTER);

		mainPanel.addRow("Java vendor", System.getProperty("java.vendor", "?"));
		mainPanel.addRow("Vendor URL", System.getProperty("java.vendor.url",
				"?"));
		mainPanel.addRow("Java version", System
				.getProperty("java.version", "?"));
		mainPanel.addRow("Java home directory", System.getProperty("java.home",
				"?"));
		mainPanel.addRow("Class version", System.getProperty(
				"java.class.version", "?"));
		mainPanel.addRow("Java compiler", System.getProperty("java.compiler",
				"?"));
		JTextArea classPathArea = new JTextArea(1, 40);
		classPathArea.setEditable(false);
		classPathArea.setText(System.getProperty("java.class.path", "?"));
		mainPanel.addRow("Java classpath", new JScrollPane(classPathArea));
		mainPanel.addRow("Java endorsed dirs.", System.getProperty(
				"java.endorsed.dirs", "?"));
		mainPanel.addRow("Java extension dirs.", System.getProperty(
				"java.ext.dirs", "?"));

		mainPanel.addRow("OS Name", System.getProperty("os.name", "?"));
		mainPanel.addRow("OS Architecture", System.getProperty("os.arch", "?"));
		mainPanel.addRow("OS Version", System.getProperty("os.version", "?"));
		mainPanel.addRow("User name", System.getProperty("user.name", "?"));
		mainPanel.addRow("User language", System.getProperty("user.language",
				"?"));
		mainPanel.addRow("User region", System.getProperty("user.region", "?"));
		mainPanel.addRow("User timezone", System.getProperty("user.timezone",
				"?"));
		mainPanel.addRow("User home directory", System.getProperty("user.home",
				"?"));
		mainPanel.addRow("User current directory", System.getProperty(
				"user.dir", "?"));

		mainPanel.addRow("File separator", System.getProperty("file.separator",
				"?"));
		mainPanel.addRow("Path separator", System.getProperty("path.separator",
				"?"));
		String property = System.getProperty("line.separator", null);
		if (property != null) {
			int ch;
			StringBuffer separators = new StringBuffer();
			for (int n = 0; n < property.length(); n++) {
				ch = property.charAt(n);
				separators.append("'0x");
				separators.append(Integer.toHexString(ch));
				separators.append("' ");
			}
			mainPanel.addRow("Line separator", separators.toString());
		}
		mainPanel.addRow("Temporary files", System.getProperty(
				"java.io.tmpdir", "?"));
		mainPanel.addRow("Default file encoding", System.getProperty(
				"file.encoding", "?"));

		mainPanel
				.addRow("Toolkit name", System.getProperty("awt.toolkit", "?"));
		Toolkit tk = Toolkit.getDefaultToolkit();
		Dimension ss = tk.getScreenSize();
		if (ss != null) {
			String screenSize = Integer.toString(ss.width) + "x"
					+ Integer.toString(ss.height);
			mainPanel.addRow("Screen size", screenSize);
		}
		mainPanel.addRow("Screen resolution DPI", Integer.toString(tk
				.getScreenResolution()));

		JPanel OKButtonPanel = new JPanel();
		OKButtonPanel.setLayout(new java.awt.FlowLayout());
		OKButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		JButton OKButton = new JButton("OK");
		OKButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				dispose();
			}
		});
		OKButtonPanel.add(OKButton);

		getContentPane().add(OKButtonPanel, BorderLayout.SOUTH);
	} // Variables declaration
}