/*
 *  Copyright 2009 joma7188.
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  under the License.
 */
package nu.zoom.util.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.naming.NamingException;

/**
 * Methods for lookin up DNS entries.
 * @see ResolverFactory
 * @author joma7188
 */
public interface Resolver {

    /**
     * Queries DNS for SRV-records for the given name.
     * @param domain The name to send to DNS. May not be null, empty or only "." a dot.
     * @return A possibly empty list of SRV records for the given name. Never null.
     */
    public List<SRVRecord> lookupSRV(String domain) throws NamingException, UnknownResponseException;

    /**
     * Lookup the A records for the given name.
     * @param domain The name to send to DNS to find A-records for.
     * @return A possibly empty list of addresses for the given name.
     * @throws NamingException
     * @throws UnknownResponseException
     * @throws UnknownHostException This is declared by InetAddress, however it
     * shouldn't in practice be thrown since InetAddress shouldn't perform a
     * DNS lookup (we've already got the A record).
     */
    public List<InetAddress> lookupA(String domain) throws NamingException, UnknownResponseException, UnknownHostException;
}
