/*
 * Copyright (C) 2004 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.text;

import java.beans.*;

/**
 * Bean info class for the ConsoleBean. This is used by GUI builders to get the
 * bean meta-information.
 * 
 * @author $Author: johan $
 * @version $Revision: 1.2 $
 */
public class ConsoleBeanBeanInfo extends SimpleBeanInfo
{
	Class<ConsoleBean> beanClass = ConsoleBean.class;
	String iconColor16x16Filename = "ConsoleBean16x16.gif";
	String iconColor32x32Filename = "ConsoleBean32x32.gif";
	String iconMono16x16Filename = "ConsoleBeanBW16x16.gif";
	String iconMono32x32Filename = "ConsoleBeanBW32x32.gif";

	public ConsoleBeanBeanInfo() {}

	public PropertyDescriptor[] getPropertyDescriptors()
	{
		try {
			PropertyDescriptor _defaultColor = new PropertyDescriptor(
					"defaultColor", beanClass, "getDefaultColor",
					"setDefaultColor");
			PropertyDescriptor _errorColor = new PropertyDescriptor(
					"errorColor", beanClass, "getErrorColor", "setErrorColor");
			PropertyDescriptor _infoColor = new PropertyDescriptor("infoColor",
					beanClass, "getInfoColor", "setInfoColor");
			PropertyDescriptor _warningColor = new PropertyDescriptor(
					"warningColor", beanClass, "getWarningColor",
					"setWarningColor");
			PropertyDescriptor[] pds = new PropertyDescriptor[] {
					_defaultColor, _errorColor, _infoColor, _warningColor };
			return pds;
		} catch (IntrospectionException ex) {
			ex.printStackTrace();
			return null;
		}
	}

	public java.awt.Image getIcon(int iconKind)
	{
		switch (iconKind) {
		case BeanInfo.ICON_COLOR_16x16:
			return iconColor16x16Filename != null ? loadImage(iconColor16x16Filename)
					: null;
		case BeanInfo.ICON_COLOR_32x32:
			return iconColor32x32Filename != null ? loadImage(iconColor32x32Filename)
					: null;
		case BeanInfo.ICON_MONO_16x16:
			return iconMono16x16Filename != null ? loadImage(iconMono16x16Filename)
					: null;
		case BeanInfo.ICON_MONO_32x32:
			return iconMono32x32Filename != null ? loadImage(iconMono32x32Filename)
					: null;
		}
		return null;
	}
}