/*
 * Copyright (C) 2006 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.field;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.swing.JLabel;
import javax.swing.text.Document;

/**
 * A labeled validating field that checks that the value in the field is a valid
 * regular expression.
 * 
 * @see java.util.regex.Pattern
 */
@SuppressWarnings("serial")
public class PatternField extends LabeledValidatingField {
	
	public PatternField(JLabel fieldLabel, Document doc, String text, int columns) {
		super(fieldLabel, doc, text, columns);
	}

	public PatternField(JLabel fieldLabel, int columns) {
		super(fieldLabel, columns);
	}

	public PatternField(JLabel fieldLabel, String text, int columns) {
		super(fieldLabel, text, columns);
	}

	public PatternField(JLabel fieldLabel, String text) {
		super(fieldLabel, text);
	}

	public PatternField(JLabel label) {
		super(label);
	}

	@Override
	protected ValidationResult validateDocument() {
		try {
			Pattern.compile(getText());
			return ValidationResult.PASSED;
		} catch (PatternSyntaxException e) {
			return new ValidationResult(e);
		}
	}
}
