/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class ConsoleBean
extends JComponent {
    private static final String DEFAULT_STYLE_NAME = "default";
    private static final String WARN_STYLE_NAME = "warn";
    private static final String ERROR_STYLE_NAME = "error";
    private static final String INFO_STYLE_NAME = "info";
    private BorderLayout mainLayout = new BorderLayout();
    private JScrollPane contentScrollPane = new JScrollPane();
    private JTextPane textPane = new JTextPane();
    private DefaultStyledDocument document;
    private Color warningColor = Color.PINK;
    private Color errorColor = Color.RED;
    private Color defaultColor = Color.BLACK;
    private Color infoColor = Color.GREEN;

    public ConsoleBean() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(this.mainLayout);
        this.textPane.setEditable(false);
        this.textPane.setContentType("text/plain");
        Document doc = this.textPane.getDocument();
        if (doc instanceof DefaultStyledDocument) {
            this.document = (DefaultStyledDocument)doc;
            this.setupStyles();
            this.add((Component)this.contentScrollPane, "Center");
            this.contentScrollPane.getViewport().add(this.textPane);
        } else {
            this.add(new JLabel("E R R O R: Unable to create default document"));
        }
    }

    private void setupStyles() {
        this.document.removeStyle(DEFAULT_STYLE_NAME);
        Style defaultStyle = this.document.addStyle(DEFAULT_STYLE_NAME, null);
        StyleConstants.setForeground(defaultStyle, this.defaultColor);
        this.document.removeStyle(WARN_STYLE_NAME);
        Style warningStyle = this.document.addStyle(WARN_STYLE_NAME, defaultStyle);
        StyleConstants.setForeground(warningStyle, this.warningColor);
        this.document.removeStyle(ERROR_STYLE_NAME);
        Style errorStyle = this.document.addStyle(ERROR_STYLE_NAME, defaultStyle);
        StyleConstants.setForeground(errorStyle, this.errorColor);
        this.document.removeStyle(INFO_STYLE_NAME);
        Style infoStyle = this.document.addStyle(INFO_STYLE_NAME, defaultStyle);
        StyleConstants.setForeground(infoStyle, this.infoColor);
    }

    public void println(String message) {
        this.print(message + "\n");
    }

    public void print(String message) {
        this.append(message, DEFAULT_STYLE_NAME);
    }

    public void warn(String message) {
        this.append(message + " \n", WARN_STYLE_NAME);
    }

    public void error(String message) {
        this.append(message + "\n", ERROR_STYLE_NAME);
    }

    public void info(String message) {
        this.append(message, INFO_STYLE_NAME);
    }

    private void append(final String message, final String styleName) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Style style = ConsoleBean.this.document.getStyle(styleName);
                try {
                    ConsoleBean.this.document.insertString(ConsoleBean.this.document.getEndPosition().getOffset() - 1, message, style);
                }
                catch (BadLocationException exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    public Color getWarningColor() {
        return this.warningColor;
    }

    public void setWarningColor(Color warningColor) {
        this.warningColor = warningColor;
        this.setupStyles();
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
        this.setupStyles();
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
        this.setupStyles();
    }

    public Color getInfoColor() {
        return this.infoColor;
    }

    public void setInfoColor(Color infoColor) {
        this.infoColor = infoColor;
        this.setupStyles();
    }
}

