/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.table;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class StringTableModel
implements TableModel {
    protected Vector<TableModelListener> listeners = new Vector();
    ArrayList<ArrayList<Object>> columns;
    String[] headers;
    int currentColumn = 0;
    int numColumns = 0;

    public StringTableModel(String[] columnNames) throws IllegalArgumentException {
        if (columnNames == null) {
            throw new IllegalArgumentException("StringTableModel can not be created with a null value for column names.");
        }
        this.numColumns = columnNames.length;
        if (this.numColumns < 1) {
            throw new IllegalArgumentException("StringTableModel can not be created with less than one column.");
        }
        this.headers = new String[this.numColumns];
        for (int n = 0; n < this.numColumns; ++n) {
            this.headers[n] = new String(columnNames[n]);
        }
        this.clear();
    }

    public void addEntry(String entry) {
        this.columns.get(this.currentColumn++).add(entry);
        if (this.currentColumn >= this.numColumns) {
            this.currentColumn = 0;
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    public void clear() {
        this.currentColumn = 0;
        this.columns = new ArrayList();
        for (int n = 0; n < this.numColumns; ++n) {
            this.columns.add(new ArrayList());
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.numColumns;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.headers[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.columns.get(0).size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.columns.get(columnIndex).get(rowIndex);
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            return "";
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.columns.get(columnIndex).set(rowIndex, aValue);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.addElement(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.removeElement(l);
    }

    protected void fireTableChanged(TableModelEvent evt) {
        int s = this.listeners.size();
        for (int n = 0; n < s; ++n) {
            this.listeners.elementAt(n).tableChanged(evt);
        }
    }

    protected void fireCellChanged(int column, int row) {
        TableModelEvent evt = new TableModelEvent(this, row, row, column);
        this.fireTableChanged(evt);
    }
}

