/*
 *  Copyright 2009 Johan Maasing.
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  under the License.
 */
package nu.zoom.util.dns;

/**
 * Indicates that we got a reply from DNS but were unable to parse the response.
 * 
 * @author Johan Maasing
 */
public class UnknownResponseException extends Exception {
	private static final long serialVersionUID = -1145192165392133615L;

	public UnknownResponseException() {
	}

	public UnknownResponseException(String msg) {
		super(msg);
	}

	public UnknownResponseException(Throwable cause) {
		super(cause);
	}

	public UnknownResponseException(String message, Throwable cause) {
		super(message, cause);
	}
}
