/*
 *  Copyright 2009 Johan Maasing johan@zoom.nu.
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  under the License.
 */
package nu.zoom.util.dns;

import nu.zoom.util.dns.impl.ResolverImpl;

/**
 * Singleton factory to get a resolver instance.
 * @author joma7188
 */
public class ResolverFactory {

    private static Resolver resolver = null;

    public static synchronized Resolver getResolver() {
        if (resolver == null) {
            resolver = new ResolverImpl();
        }
        return resolver;
    }
    /*
    public static void main(String[] args) throws UnknownResponseException, NamingException, UnknownHostException {
    Resolver test = getResolver();
    List<SRVRecord> result = test.lookupSRV("_ldap._tcp.sigma.local");
    System.out.println("Number of results: " + result.size());
    for (SRVRecord record : result) {
    System.out.println(record);
    }

    List<InetAddress> resultA = test.lookupA("www.sunet.se");
    System.out.println("Number of results: " + resultA.size());
    for (InetAddress record : resultA) {
    System.out.println(record);
    }
    }
     */
}
