/*
 * Copyright (C) 2004 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.text;

import java.awt.*;
import javax.swing.*;

/**
 * A simple status bar component.
 * 
 * @author $Author: johan $
 * @version $Revision: 1.4 $
 */

@SuppressWarnings("serial")
public class StatusBarBean extends JComponent
{

	private JLabel statusText = new JLabel();
	private JProgressBar workIndicator;

	public StatusBarBean() {
		this.setLayout(new BorderLayout());
		workIndicator = new JProgressBar(JProgressBar.HORIZONTAL);
		this.add(statusText, BorderLayout.CENTER);
		this.add(workIndicator, BorderLayout.WEST);
	}

	/**
	 * Write a string on the status bar. This method is thread safe and may be
	 * called from any thread.
	 * 
	 * @param message
	 *            The text to display on the status bar.
	 */
	public void setMessage(final String message) {
		EventQueue.invokeLater(new Runnable() {

			public void run() {
				statusText.setText(message);
			}
		});
	}

	/**
	 * Start the indicator of work in progress. May be called from any thread.
	 *  
	 */
	public void startWorkIndicator() {
		EventQueue.invokeLater(new Runnable() {

			public void run() {
				workIndicator.setIndeterminate(true);
			}
		});
	}

	/**
	 * Stop the work in progress indicator. May be called from any thread.
	 *  
	 */
	public void stopWorkIndicator() {
		EventQueue.invokeLater(new Runnable() {

			public void run() {
				workIndicator.setIndeterminate(false);
			}
		});
	}
}