/**
 * 
 */
package nu.zoom.swing.field;

import javax.swing.JLabel;
import javax.swing.text.Document;

/**
 * Validates the field by trying to parse it as an integer.
 * 
 * @see java.lang.Integer#parseInt(java.lang.String)
 */
public class IntegerField extends LabeledValidatingField {
	private static final long serialVersionUID = 3395416335393670092L;

	/**
	 * @param fieldLabel
	 */
	public IntegerField(JLabel fieldLabel) {
		super(fieldLabel);
	}

	/**
	 * @param fieldLabel
	 * @param doc
	 * @param text
	 * @param columns
	 */
	public IntegerField(JLabel fieldLabel, Document doc, String text, int columns) {
		super(fieldLabel, doc, text, columns);
	}

	/**
	 * @param fieldLabel
	 * @param columns
	 */
	public IntegerField(JLabel fieldLabel, int columns) {
		super(fieldLabel, columns);
	}

	/**
	 * @param fieldLabel
	 * @param text
	 * @param columns
	 */
	public IntegerField(JLabel fieldLabel, String text, int columns) {
		super(fieldLabel, text, columns);
	}

	/**
	 * @param fieldLabel
	 * @param text
	 */
	public IntegerField(JLabel fieldLabel, String text) {
		super(fieldLabel, text);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.field.LabeledValidatingField#validateDocument()
	 */
	@Override
	protected ValidationResult validateDocument() {
		try {
			Integer.parseInt(getText());
			return ValidationResult.PASSED;
		} catch (NumberFormatException e) {
			return new ValidationResult(e);
		}
	}

}
