package nu.zoom.swing.field;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

/**
 * A textfield that issues a callback method when the text document is changed.
 * @author "Johan Maasing" &lt;johan@zoom.nu&gt;
 */
public abstract class DocumentListeningField extends JTextField implements
		DocumentListener {
	private static final long serialVersionUID = 7779432922295904734L;

	public DocumentListeningField() {
		super();
		getDocument().addDocumentListener(this);
	}

	public DocumentListeningField(Document doc, String text, int columns) {
		super(doc, text, columns);
		getDocument().addDocumentListener(this);
	}

	public DocumentListeningField(int columns) {
		super(columns);
		getDocument().addDocumentListener(this);
	}

	public DocumentListeningField(String text, int columns) {
		super(text, columns);
		getDocument().addDocumentListener(this);
	}

	public DocumentListeningField(String text) {
		super(text);
		getDocument().addDocumentListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
	 */
	public synchronized void changedUpdate(DocumentEvent e) {
		documentChanged();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
	 */
	public synchronized void insertUpdate(DocumentEvent e) {
		documentChanged();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
	 */
	public synchronized void removeUpdate(DocumentEvent e) {
		documentChanged();
	}

	/**
	 * This method will be called when the document backing this field is
	 * changed. The callback will be in the EventQueue thread.
	 */
	protected abstract void documentChanged();
}
