/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.worker;

import java.awt.EventQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nu.zoom.swing.desktop.worker.EventQueuePolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkerInvocationHandler
implements InvocationHandler {
    private Log log = LogFactory.getLog(this.getClass());
    private Object instance;
    private ThreadGroup threadGroup = new ThreadGroup("Worker threads");

    public WorkerInvocationHandler(Object instance) {
        this.instance = instance;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        EventQueuePolicy policy = method.getAnnotation(EventQueuePolicy.class);
        if (policy == null) {
            return method.invoke(this.instance, args);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Event queue policy detected for method: " + method.getName()));
        }
        boolean noDelayedResult = Void.TYPE.equals(method.getReturnType()) && method.getExceptionTypes().length == 0;
        switch (policy.value()) {
            case EVENT_QUEUE: {
                if (EventQueue.isDispatchThread()) {
                    return method.invoke(this.instance, args);
                }
                this.log.trace((Object)("Dispatching method call to EventQueue, wait for result: " + noDelayedResult));
                if (noDelayedResult) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                method.invoke(WorkerInvocationHandler.this.instance, args);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("Worker thread method threw undeclared exception", e);
                            }
                        }
                    });
                    return null;
                }
                DelayedResultWorker worker = new DelayedResultWorker(this.instance, method, args);
                this.invokeAndWait(worker, true);
                if (worker.exception != null) {
                    throw worker.exception;
                }
                return worker.result;
            }
            case NOT_EVENT_QUEUE: {
                if (EventQueue.isDispatchThread()) {
                    this.log.trace((Object)("Dispatching method call to new thread, wait for result: " + noDelayedResult));
                    if (noDelayedResult) {
                        Thread t = new Thread(this.threadGroup, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    method.invoke(WorkerInvocationHandler.this.instance, args);
                                }
                                catch (Exception e) {
                                    throw new IllegalStateException("Worker thread method threw undeclared exception", e);
                                }
                            }
                        });
                        t.start();
                        return null;
                    }
                    DelayedResultWorker worker = new DelayedResultWorker(this.instance, method, args);
                    this.invokeAndWait(worker, false);
                    if (worker.exception != null) {
                        throw worker.exception;
                    }
                    return worker.result;
                }
                return method.invoke(this.instance, args);
            }
        }
        return method.invoke(this.instance, args);
    }

    private void invokeAndWait(DelayedResultWorker worker, boolean eventQueue) throws InterruptedException {
        if (eventQueue) {
            EventQueue.invokeLater(worker);
        } else {
            Thread t = new Thread(this.threadGroup, worker);
            t.start();
        }
        worker.waitForResult();
    }

    public String toString() {
        return "Event queue interceptor for : " + this.instance.getClass().getName();
    }

    class DelayedResultWorker
    implements Runnable {
        private Object result = null;
        private Exception exception = null;
        private Object instance;
        private Method method;
        private Object[] args;

        DelayedResultWorker(Object instance, Method method, Object[] args) {
            this.instance = instance;
            this.method = method;
            this.args = args;
        }

        synchronized void setResult(Object result) {
            this.result = result;
        }

        synchronized void setException(Exception e) {
            this.exception = e instanceof InvocationTargetException && e.getCause() != null && e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
        }

        synchronized boolean isResult() {
            return this.result != null || this.exception != null;
        }

        synchronized void waitForResult() {
            WorkerInvocationHandler.this.log.trace((Object)"Waiting for worker result");
            while (!this.isResult()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.setException(e);
                }
            }
            WorkerInvocationHandler.this.log.trace((Object)"Worker result obtained");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                Object resultObject = this.method.invoke(this.instance, this.args);
                this.setResult(resultObject);
            }
            catch (Exception e) {
                this.setException(e);
            }
            finally {
                this.notifyAll();
            }
        }
    }
}

