/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.workbench;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchMenuBar;
import nu.zoom.swing.desktop.component.ASF2LicensePanel;
import org.ops4j.gaderian.Messages;

public class WorkbenchMenuBarImpl
implements WorkbenchMenuBar {
    private Hashtable<String, JMenu> menues = new Hashtable();
    private JMenuBar menuBar;
    private Workbench workbench;
    private JMenu helpMenu = null;
    private JMenu applicationMenu = null;
    private Messages messages;

    public WorkbenchMenuBarImpl(Workbench workbench, Messages messages) {
        this.workbench = workbench;
        this.messages = messages;
        this.menuBar = new JMenuBar();
        String applicationMenuTitle = messages.getMessage("menu.application");
        this.applicationMenu = new JMenu(applicationMenuTitle);
        this.applicationMenu.setMnemonic(65);
        this.applicationMenu.addSeparator();
        ExitAction exitAction = new ExitAction(messages.getMessage("menuitem.exit"));
        JMenuItem exitMenuItem = new JMenuItem(exitAction);
        exitMenuItem.setMnemonic(88);
        this.applicationMenu.add(exitMenuItem);
        String helpMenuTitle = messages.getMessage("menu.help");
        this.helpMenu = new JMenu(helpMenuTitle);
        this.helpMenu.setMnemonic(80);
        this.helpMenu.add(new LicenseAction(messages.getMessage("menuitem.license")));
        this.buildMenuBar();
    }

    @Override
    public void addMenu(final String menuKey, final JMenu menu) throws IllegalArgumentException {
        if (menuKey == null || menuKey.length() < 1) {
            throw new IllegalArgumentException("Menu key can not be null or zero length");
        }
        if (menu == null) {
            throw new IllegalArgumentException("Can not add null for menu value");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkbenchMenuBarImpl.this.addMenuImpl(menuKey, menu);
            }
        });
    }

    private void buildMenuBar() {
        this.menuBar.add(this.applicationMenu);
        Enumeration<String> keyEnum = this.menues.keys();
        while (keyEnum.hasMoreElements()) {
            JMenu currentMenu = this.menues.get(keyEnum.nextElement());
            this.menuBar.add(currentMenu);
        }
        this.menuBar.add(this.helpMenu);
        this.menuBar.revalidate();
    }

    private synchronized void addMenuImpl(String menuKey, JMenu menu) {
        this.menuBar.removeAll();
        this.menues.put(menuKey, menu);
        this.buildMenuBar();
    }

    @Override
    public JMenu getMenu(String menuKey) {
        if ("nu.zoom.swing.desktop.gui.workbench.menu.help".equals(menuKey)) {
            return this.applicationMenu;
        }
        if ("nu.zoom.swing.desktop.gui.workbench.menu.help".equals(menuKey)) {
            return this.helpMenu;
        }
        return this.menues.get(menuKey);
    }

    @Override
    public void removeMenu(final String menuKey) {
        if (menuKey != null && menuKey.length() > 0 && !menuKey.equals("nu.zoom.swing.desktop.gui.workbench.menu.help") && !menuKey.equals("nu.zoom.swing.desktop.gui.workbench.menu.help")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorkbenchMenuBarImpl.this.removeMenuImpl(menuKey);
                }
            });
        }
    }

    private synchronized void removeMenuImpl(String menuKey) {
        JMenu removedMenu = this.menues.remove(menuKey);
        if (removedMenu != null) {
            this.menuBar.removeAll();
            this.buildMenuBar();
        }
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    @Override
    public void addToApplicationMenu(final JMenuItem item) throws IllegalArgumentException {
        if (item == null) {
            throw new IllegalArgumentException("item to add to application menu can not be null");
        }
        if (EventQueue.isDispatchThread()) {
            this.applicationMenu.insert(item, 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorkbenchMenuBarImpl.this.applicationMenu.insert(item, 0);
                }
            });
        }
    }

    @Override
    public void addToHelpMenu(final JMenuItem item) throws IllegalArgumentException {
        if (item == null) {
            throw new IllegalArgumentException("item to add to application menu can not be null");
        }
        if (EventQueue.isDispatchThread()) {
            this.helpMenu.add(item);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorkbenchMenuBarImpl.this.helpMenu.add(item);
                }
            });
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction(String title) {
            super(title);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkbenchMenuBarImpl.this.workbench.close();
        }
    }

    class LicenseAction
    extends AbstractAction {
        LicenseAction(String title) {
            super(title);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkbenchFrame frame = WorkbenchMenuBarImpl.this.workbench.createWorkbenchFrame(ASF2LicensePanel.class.getName(), new ASF2LicensePanel(), true, true);
            frame.setTitle(WorkbenchMenuBarImpl.this.messages.getMessage("window.title.license"));
            frame.setVisible(true);
        }
    }
}

