/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import nu.zoom.swing.desktop.CloseVetoListener;
import nu.zoom.swing.desktop.ErrorReporter;
import nu.zoom.swing.desktop.PlugIn;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchListener;
import nu.zoom.swing.desktop.WorkbenchMenuBar;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.frame.Desktop;
import nu.zoom.swing.desktop.preferences.Preferences;
import nu.zoom.swing.desktop.workbench.ErrorReporterImpl;
import nu.zoom.swing.desktop.workbench.WorkbenchMenuBarImpl;
import nu.zoom.swing.text.StatusBarBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

public class WorkbenchImpl
implements Workbench {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String PREFS_POSITION_X = "workbench.posx";
    private static final String PREFS_POSITION_Y = "workbench.posy";
    private static final String PREFS_WIDTH = "workbench.width";
    private static final String PREFS_HEIGHT = "workbench.height";
    private JFrame mainFrame;
    private WorkbenchMenuBarImpl workbenchMenuBar;
    private Preferences preferences;
    private Desktop desktop;
    private boolean restarting = false;
    private boolean closing = false;
    private boolean starting = false;
    private boolean listenersStarting = false;
    private Messages messages;
    private final ArrayList<WorkbenchListener> workbenchListeners = new ArrayList();
    private final ArrayList<CloseVetoListener> closeVetoListeners = new ArrayList();
    private PlugIn lafManager;
    private StatusBarBean statusBar;
    private List<PlugIn> pluginList;

    public WorkbenchImpl(Preferences preferences, PlugIn lafManager, Messages messages, List<PlugIn> pluginList) {
        this.preferences = preferences;
        this.messages = messages;
        this.lafManager = lafManager;
        this.pluginList = pluginList;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    @Override
    public synchronized void start() {
        this.log.trace((Object)"Trying to start workbench");
        if (this.starting) {
            this.log.info((Object)"Workbench is already starting");
            return;
        }
        this.starting = true;
        try {
            this.log.trace((Object)"Initializing LAF manager");
            this.lafManager.initialize();
        }
        catch (Exception exc) {
            System.err.println(exc);
            System.exit(-1);
        }
        if (!EventQueue.isDispatchThread()) {
            this.log.trace((Object)"Not running in EventQueue thread, dispatching workbench start to EventQueue");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorkbenchImpl.this.startOnEventQueue();
                }
            });
        } else {
            this.startOnEventQueue();
        }
    }

    private synchronized void startOnEventQueue() {
        this.workbenchMenuBar = new WorkbenchMenuBarImpl(this, this.messages);
        this.desktop = new Desktop(this.messages, this.workbenchMenuBar, this.preferences, this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 1024;
        int height = 768;
        int posx = screenSize.width / 2 - width / 2;
        int posy = screenSize.height / 2 - height / 2;
        try {
            Integer prefPosX = this.preferences.getInteger(PREFS_POSITION_X);
            Integer prefPosY = this.preferences.getInteger(PREFS_POSITION_Y);
            Integer prefWidth = this.preferences.getInteger(PREFS_WIDTH);
            Integer prefHeight = this.preferences.getInteger(PREFS_HEIGHT);
            posx = prefPosX != null ? prefPosX : posx;
            posy = prefPosY != null ? prefPosY : posy;
            width = prefWidth != null ? prefWidth : width;
            height = prefHeight != null ? prefHeight : height;
        }
        catch (Exception exc) {
            this.log.error((Object)"Unable to retrieve workbench position and size from preferences", (Throwable)exc);
        }
        if (posx < 0) {
            this.log.trace((Object)"Position outside screen, clamping");
            posx = 0;
        } else if (posx > screenSize.width) {
            this.log.trace((Object)"Position outside screen, clamping");
            posx = 0;
        }
        if (posy < 0) {
            this.log.trace((Object)"Position outside screen, clamping");
            posy = 0;
        } else if (posy > height) {
            this.log.trace((Object)"Position outside screen, clamping");
            posy = 0;
        }
        if (posx + width > screenSize.width) {
            this.log.trace((Object)"Width outside screen, clamping");
            width = screenSize.width - posx;
        }
        if (posy + height > screenSize.height) {
            this.log.trace((Object)"Height outside screen, clamping");
            height = screenSize.height - posy;
        }
        this.log.trace((Object)("Workbench position: x=" + posx + " y=" + posy + " width=" + width + " height=" + height));
        String title = "";
        title = this.messages.getMessage("window.title.workbench");
        this.statusBar = new StatusBarBean();
        this.mainFrame = new JFrame(title);
        this.mainFrame.setJMenuBar(this.workbenchMenuBar.getJMenuBar());
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.desktop.getDesktopPane(), "Center");
        this.mainFrame.getContentPane().add((Component)this.statusBar, "South");
        this.mainFrame.setLocation(posx, posy);
        this.mainFrame.setSize(width, height);
        this.mainFrame.validate();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorkbenchImpl.this.close();
            }
        });
        if (!this.restarting) {
            this.log.trace((Object)"Initializing workbench plug-ins");
            for (PlugIn plugIn : this.pluginList) {
                try {
                    this.log.trace((Object)("Initializing plugin: " + plugIn));
                    plugIn.initialize();
                }
                catch (Exception exc) {
                    this.log.error((Object)"Unable to initialize plug-in", (Throwable)exc);
                }
            }
        }
        this.fireStart();
        this.mainFrame.setVisible(true);
        this.starting = false;
    }

    private synchronized void fireStart() {
        this.listenersStarting = true;
        for (WorkbenchListener listener : this.workbenchListeners) {
            listener.start();
        }
        this.listenersStarting = false;
    }

    @Override
    public synchronized WorkbenchFrame createWorkbenchFrame(String preferencesKey, JComponent content, JMenuBar menu, boolean resizable, boolean maximizable) {
        this.log.trace((Object)"Creating workbench frame instance");
        WorkbenchFrame wframe = this.desktop.createFrame(preferencesKey, content, menu, resizable, maximizable);
        return wframe;
    }

    @Override
    public synchronized WorkbenchFrame createWorkbenchFrame(String prefsKey, JComponent content, boolean resizable, boolean maximizable) {
        return this.createWorkbenchFrame(prefsKey, content, null, resizable, maximizable);
    }

    @Override
    public Frame getDialogOwner() {
        return this.mainFrame;
    }

    @Override
    public synchronized void close() {
        this.log.trace((Object)"Trying to close workbench");
        if (this.mainFrame == null) {
            this.log.fatal((Object)"Workbench not started, unable to stop");
            throw new IllegalStateException("Workbench must be started before you can close it");
        }
        if (this.closing) {
            this.log.trace((Object)"Workbench already stopping");
            return;
        }
        this.closing = true;
        this.log.trace((Object)"Checking if any registered listeners veto the close");
        for (CloseVetoListener closeVetoListener : this.closeVetoListeners) {
            if (closeVetoListener.canClose()) continue;
            this.log.trace((Object)"Listener veto'ed the close operation, aborting close");
            this.closing = false;
            return;
        }
        this.log.trace((Object)"Informing listeners that workbench is closing");
        for (WorkbenchListener workbenchListener : this.workbenchListeners) {
            workbenchListener.close();
        }
        if (!this.restarting) {
            this.log.trace((Object)"Dropping references to listeners");
            this.workbenchListeners.clear();
            this.closeVetoListeners.clear();
        }
        this.log.trace((Object)"Close all frames");
        this.desktop.closeAll();
        Point location = this.mainFrame.getLocation();
        Dimension dimension = this.mainFrame.getSize();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Trying to save workbench position: " + location + " and size " + dimension));
        }
        try {
            this.preferences.setInteger(PREFS_POSITION_X, new Integer(location.x));
            this.preferences.setInteger(PREFS_POSITION_Y, new Integer(location.y));
            this.preferences.setInteger(PREFS_WIDTH, new Integer(dimension.width));
            this.preferences.setInteger(PREFS_HEIGHT, new Integer(dimension.height));
        }
        catch (BackendException exc) {
            this.log.error((Object)"Unable to saze workbench location and size to preferences", (Throwable)exc);
        }
        this.log.trace((Object)"Disposing of main frame");
        this.mainFrame.dispose();
        this.closing = false;
    }

    @Override
    public synchronized void restartGUI() {
        this.log.trace((Object)"Trying to restart workbench");
        if (this.restarting) {
            this.log.trace((Object)"Workbench is already restarting");
            return;
        }
        this.restarting = true;
        this.close();
        this.startOnEventQueue();
        this.restarting = false;
    }

    @Override
    public void setTitle(String workbenchTitle) {
        if (this.mainFrame == null) {
            this.log.fatal((Object)"Workbench must be started before you can set a title");
            throw new IllegalStateException("Workbench must be started before you can set a title");
        }
        this.log.trace((Object)("Setting workbench title: " + workbenchTitle));
        this.mainFrame.setTitle(workbenchTitle);
    }

    @Override
    public void setIcon(List<ImageIcon> imageIcons) {
        if (this.mainFrame == null) {
            this.log.fatal((Object)"Workbench must be started before you can set an icon");
            throw new IllegalStateException("Workbench must be started before you can set an icon");
        }
        this.log.trace((Object)"Setting workbench icon");
        ArrayList<Image> images = new ArrayList<Image>();
        if (imageIcons != null) {
            for (ImageIcon imageIcon : imageIcons) {
                images.add(imageIcon.getImage());
            }
        }
        this.mainFrame.setIconImages(images);
    }

    @Override
    public synchronized ErrorReporter getErrorReporter() {
        return new ErrorReporterImpl(this, this.messages);
    }

    @Override
    public synchronized void addWorkBenchListener(final WorkbenchListener listener) {
        if (listener != null) {
            if (this.listenersStarting) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkbenchImpl.this.workbenchListeners.add(listener);
                    }
                });
            } else {
                this.workbenchListeners.add(listener);
            }
        }
    }

    @Override
    public synchronized void removeWorkBenchListener(WorkbenchListener listener) {
        this.workbenchListeners.remove(listener);
    }

    @Override
    public synchronized void addCloseVetoListener(CloseVetoListener listener) {
        if (listener != null) {
            this.closeVetoListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeCloseVetoListener(CloseVetoListener listener) {
        this.closeVetoListeners.remove(listener);
    }

    @Override
    public WorkbenchMenuBar getMenuBar() {
        return this.workbenchMenuBar;
    }

    @Override
    public void setStatusbarMessage(String message) {
        this.statusBar.setMessage(message);
    }

    @Override
    public void startWorkIndicator() {
        this.statusBar.startWorkIndicator();
    }

    @Override
    public void stopWorkIndicator() {
        this.statusBar.stopWorkIndicator();
    }

    @Override
    public void registerKeyboardAction(ActionListener anAction, KeyStroke aKeyStroke, int aCondition) {
        this.desktop.registerKeyboardAction(anAction, aKeyStroke, aCondition);
    }

    @Override
    public void registerKeyboardAction(ActionListener anAction, String aCommand, KeyStroke aKeyStroke, int aCondition) {
        this.desktop.registerKeyboardAction(anAction, aCommand, aKeyStroke, aCondition);
    }
}

