/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.workbench;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import nu.zoom.swing.desktop.ErrorReporter;
import nu.zoom.swing.desktop.Workbench;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

public class ErrorReporterImpl
implements ErrorReporter {
    private Log log = LogFactory.getLog(this.getClass());
    private Workbench workbench;
    private Messages messages;

    public ErrorReporterImpl(Workbench workbench, Messages messages) {
        this.workbench = workbench;
        this.messages = messages;
    }

    @Override
    public void reportError(Exception e) {
        this.showErrorDialog(null, e);
    }

    @Override
    public void reportError(String message) {
        this.showErrorDialog(message, null);
    }

    @Override
    public void reportError(String message, Exception e) {
        this.showErrorDialog(message, e);
    }

    private void showErrorDialog(final String message, final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JDialog errorDialog = new JDialog(ErrorReporterImpl.this.workbench.getDialogOwner());
                errorDialog.getContentPane().setLayout(new BorderLayout());
                String errorDialogTitleString = "Error";
                errorDialogTitleString = ErrorReporterImpl.this.messages.getMessage("window.title.errorreporter");
                errorDialog.setTitle(errorDialogTitleString);
                String closeString = "Close";
                closeString = ErrorReporterImpl.this.messages.getMessage("button.close");
                JButton closeButton = new JButton(closeString);
                closeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        errorDialog.dispose();
                    }
                });
                JPanel buttonPane = new JPanel();
                buttonPane.add(closeButton);
                errorDialog.getContentPane().add((Component)buttonPane, "South");
                String errorMessageString = message == null ? (e != null ? e.getLocalizedMessage() : "") : message;
                JLabel errorMessage = new JLabel(errorMessageString);
                Font stderrorFont = errorMessage.getFont();
                Font errorFont = stderrorFont.deriveFont(1);
                errorMessage.setFont(errorFont);
                errorMessage.setForeground(Color.RED);
                errorDialog.getContentPane().add((Component)errorMessage, "North");
                if (e != null) {
                    StringBuffer traceBuffer = new StringBuffer();
                    traceBuffer.append(e.toString());
                    traceBuffer.append("\n-----------------\n");
                    StackTraceElement[] trace = e.getStackTrace();
                    for (int i = 0; i < trace.length; ++i) {
                        traceBuffer.append(trace[i].toString());
                        traceBuffer.append("\n");
                    }
                    JTextArea traceArea = new JTextArea(traceBuffer.toString(), 10, 80);
                    traceArea.setEditable(false);
                    errorDialog.getContentPane().add((Component)new JScrollPane(traceArea), "Center");
                }
                errorDialog.pack();
                errorDialog.setLocationRelativeTo(ErrorReporterImpl.this.workbench.getDialogOwner());
                errorDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                errorDialog.setVisible(true);
            }
        });
    }
}

