/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.preferences.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.preferences.InvalidDataTypeException;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencesImpl
implements Preferences {
    private Log log = LogFactory.getLog(this.getClass());
    private java.util.prefs.Preferences rootNode = java.util.prefs.Preferences.userNodeForPackage(Preferences.class);

    public PreferencesImpl() {
        this.log.trace((Object)("Created preferences, root node: " + this.rootNode.absolutePath()));
    }

    @Override
    public String getString(String key) throws InvalidDataTypeException, BackendException {
        this.assertValidKey(key);
        return this.rootNode.get(key, null);
    }

    @Override
    public void setString(String key, String value) throws BackendException {
        this.assertValidKey(key);
        if (value != null) {
            this.rootNode.put(key, value);
        } else {
            this.rootNode.remove(key);
        }
        try {
            this.rootNode.sync();
        }
        catch (BackingStoreException e) {
            throw new BackendException("Unable to flush preference node", e);
        }
    }

    @Override
    public Integer getInteger(String key) throws InvalidDataTypeException, BackendException {
        this.assertValidKey(key);
        String sValue = this.rootNode.get(key, null);
        if (sValue == null) {
            return null;
        }
        try {
            int iValue = Integer.parseInt(sValue);
            return new Integer(iValue);
        }
        catch (NumberFormatException e) {
            throw new InvalidDataTypeException(sValue + " is not an integer");
        }
    }

    @Override
    public void setInteger(String key, Integer value) throws BackendException {
        this.assertValidKey(key);
        if (value != null) {
            this.rootNode.put(key, value.toString());
        } else {
            this.rootNode.remove(key);
        }
        try {
            this.rootNode.sync();
        }
        catch (BackingStoreException e) {
            throw new BackendException("Unable to flush preference node", e);
        }
    }

    @Override
    public byte[] getBytes(String key) throws InvalidDataTypeException, BackendException {
        this.assertValidKey(key);
        return this.rootNode.getByteArray(key, null);
    }

    @Override
    public void setBytes(String key, byte[] value) throws BackendException {
        this.assertValidKey(key);
        if (value != null) {
            this.rootNode.putByteArray(key, value);
        } else {
            this.rootNode.remove(key);
        }
        try {
            this.rootNode.sync();
        }
        catch (BackingStoreException e) {
            throw new BackendException("Unable to flush preference node", e);
        }
    }

    @Override
    public Set<String> getStrings(String key) throws InvalidDataTypeException, BackendException {
        this.assertValidKey(key);
        java.util.prefs.Preferences node = this.rootNode.node(key);
        HashSet<String> set = new HashSet<String>();
        try {
            String[] childNodeNames = node.childrenNames();
            for (int i = 0; i < childNodeNames.length; ++i) {
                java.util.prefs.Preferences childNode = node.node(childNodeNames[i]);
                set.add(childNode.get("value", null));
            }
        }
        catch (BackingStoreException exc) {
            throw new BackendException("Unable to read preference child nodes", exc);
        }
        return set;
    }

    @Override
    public void setStrings(String key, Set<String> values) throws BackendException {
        this.assertValidKey(key);
        java.util.prefs.Preferences node = this.rootNode.node(key);
        try {
            if (node.nodeExists("")) {
                node.removeNode();
            }
            if (node.nodeExists("")) {
                throw new BackendException("Unable to remove Preferences-node " + key);
            }
            node = this.rootNode.node(key);
        }
        catch (BackingStoreException e1) {
            throw new BackendException("Unable to remove Preferences-node " + key);
        }
        if (values != null) {
            int counter = 0;
            for (String value : values) {
                java.util.prefs.Preferences childNode = node.node("" + counter);
                ++counter;
                childNode.put("value", value);
            }
            try {
                this.rootNode.sync();
            }
            catch (BackingStoreException e) {
                throw new BackendException("Unable to flush preference node", e);
            }
        }
    }

    private void assertValidKey(String key) {
        if (key == null || key.length() < 1) {
            this.log.error((Object)"Preferences key may not be null or zero length");
            throw new IllegalArgumentException("Preferences key may not be null or zero length");
        }
        if (key.indexOf("/") != -1) {
            this.log.error((Object)("Preferences key may not contain '/' : " + key));
            throw new IllegalArgumentException("Preferences key may not contain '/'");
        }
    }
}

