/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.plugin.laf;

import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import nu.zoom.swing.desktop.PlugIn;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchListener;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.plugin.laf.ActivateLookAndFeelAction;
import nu.zoom.swing.desktop.plugin.laf.ConfigurableDesktopLookAndFeel;
import nu.zoom.swing.desktop.plugin.laf.ConfigureLookAndFeelAction;
import nu.zoom.swing.desktop.plugin.laf.DesktopLookAndFeel;
import nu.zoom.swing.desktop.plugin.laf.InstalledLookAndFeel;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

public class LookAndFeelManager
implements PlugIn,
WorkbenchListener {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String PREFERRED_LAF_PREFS_KEY = "LookAndFeel";
    private Preferences preferences;
    private Workbench workbench;
    private Messages messages;
    private ArrayList<DesktopLookAndFeel> availableLAFs = new ArrayList();
    private List<DesktopLookAndFeel> lookAndFeelServices;

    public LookAndFeelManager(Workbench workbench, Messages messages, Preferences preferences, List<DesktopLookAndFeel> lookAndFeelServices) {
        this.workbench = workbench;
        this.messages = messages;
        this.preferences = preferences;
        this.lookAndFeelServices = lookAndFeelServices;
    }

    @Override
    public void initialize() throws Exception {
        String preferredLAFName = null;
        try {
            preferredLAFName = this.preferences.getString(PREFERRED_LAF_PREFS_KEY);
        }
        catch (Exception e) {
            // empty catch block
        }
        UIManager.LookAndFeelInfo[] installedLAFsInfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < installedLAFsInfo.length; ++i) {
            String classname = installedLAFsInfo[i].getClassName();
            this.log.trace((Object)("Trying to load Installed LAF class:" + classname));
            Class<?> lafClass = this.getClass().getClassLoader().loadClass(classname);
            LookAndFeel laf = (LookAndFeel)lafClass.newInstance();
            if (!laf.isSupportedLookAndFeel()) continue;
            this.log.trace((Object)"LAF reported it was supported by the platform");
            if (laf instanceof WindowsClassicLookAndFeel) continue;
            this.log.trace((Object)"LAf was not WindowsClassicLookAndFeel, adding LAF");
            this.availableLAFs.add(new InstalledLookAndFeel(laf));
        }
        for (DesktopLookAndFeel laf : this.lookAndFeelServices) {
            if (!laf.isAvailable()) continue;
            this.log.trace((Object)("LAF " + laf.getName() + " is available"));
            this.availableLAFs.add(laf);
        }
        if (preferredLAFName != null) {
            this.log.trace((Object)("Trying to set the preferred LAF to: " + preferredLAFName));
            for (DesktopLookAndFeel laf : this.availableLAFs) {
                if (!preferredLAFName.equals(laf.getName())) continue;
                try {
                    laf.initialize();
                }
                catch (UnsupportedLookAndFeelException exc) {
                    this.log.warn((Object)"Preferred LAF could not be set, trying fallback LAF");
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                    catch (Exception exc1) {
                        this.log.fatal((Object)"Tried to fallback to cross platform LAF but failed", (Throwable)exc1);
                        System.err.println("Tried to fallback to cross platform LAF but failed");
                        exc1.printStackTrace();
                    }
                }
            }
        }
        this.workbench.addWorkBenchListener(this);
    }

    @Override
    public void close() {
    }

    @Override
    public void start() {
        if (this.availableLAFs.size() > 0) {
            String preferredLAFName = null;
            try {
                preferredLAFName = this.preferences.getString(PREFERRED_LAF_PREFS_KEY);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Preferred LAF from preferences: " + preferredLAFName));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (preferredLAFName == null) {
                preferredLAFName = UIManager.getLookAndFeel().getName();
            }
            this.log.trace((Object)"Creating LAF menu");
            JMenu lafMenu = new JMenu(this.messages.getMessage("menu.laf"));
            lafMenu.setMnemonic(76);
            lafMenu.setToolTipText(this.messages.getMessage("menu.laf.tooltip"));
            ButtonGroup lafGroup = new ButtonGroup();
            for (int i = 0; i < this.availableLAFs.size(); ++i) {
                DesktopLookAndFeel laf = this.availableLAFs.get(i);
                JRadioButtonMenuItem lafMenuItem = new JRadioButtonMenuItem(new ActivateLookAndFeelAction(this, laf));
                lafGroup.add(lafMenuItem);
                lafMenu.add(lafMenuItem);
                if (preferredLAFName == null || !preferredLAFName.equals(laf.getName())) continue;
                lafMenuItem.setSelected(true);
            }
            boolean separatorDrawn = false;
            for (int i = 0; i < this.availableLAFs.size(); ++i) {
                if (!(this.availableLAFs.get(i) instanceof ConfigurableDesktopLookAndFeel)) continue;
                if (!separatorDrawn) {
                    lafMenu.addSeparator();
                    separatorDrawn = true;
                }
                ConfigurableDesktopLookAndFeel claf = (ConfigurableDesktopLookAndFeel)this.availableLAFs.get(i);
                ConfigureLookAndFeelAction action = new ConfigureLookAndFeelAction(this.workbench, this.messages, claf);
                lafMenu.add((JMenuItem)action.getControl());
            }
            this.workbench.getMenuBar().addToApplicationMenu(lafMenu);
        }
    }

    public void changeLookAndFeel(DesktopLookAndFeel desktopLAF) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Trying to store preferred LAF: " + desktopLAF.getName() + " in preferences"));
        }
        try {
            this.preferences.setString(PREFERRED_LAF_PREFS_KEY, desktopLAF.getName());
        }
        catch (BackendException e) {
            this.log.error((Object)"Unable to store preferred LAF", (Throwable)e);
            this.workbench.getErrorReporter().reportError(this.messages.format("error.preferences", (Object)PREFERRED_LAF_PREFS_KEY), e);
        }
        try {
            this.log.trace((Object)"Calling UIManager.setLookAndFeel");
            desktopLAF.initialize();
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            SwingUtilities.updateComponentTreeUI(this.workbench.getDialogOwner());
        }
        catch (UnsupportedLookAndFeelException exc) {
            this.log.warn((Object)"Unable to change LAF, fallback to cross platform LAF", (Throwable)exc);
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exc1) {
                this.log.error((Object)"Tried to fallback to cross platform LAF but failed", (Throwable)exc1);
                System.err.println("Tried to fallback to cross platform LAF but failed");
                exc1.printStackTrace();
            }
            this.workbench.getErrorReporter().reportError(this.messages.getMessage("unsupportedlaf"), exc);
        }
    }
}

