/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.plugin.console;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchFrameListener;
import nu.zoom.swing.desktop.WorkbenchListener;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.plugin.console.Console;
import nu.zoom.swing.desktop.preferences.Preferences;
import nu.zoom.swing.text.ConsoleBean;
import nu.zoom.swing.text.ConsoleBeanBeanInfo;
import org.ops4j.gaderian.Messages;

public class ConsoleImpl
implements WorkbenchListener,
Console {
    private static final String IS_CONSOLE_WINDOW_VISIBLE = "nu.zoom.desktop.plugin.console";
    private Messages messages;
    private Workbench workbench;
    private WorkbenchFrame consoleFrame = null;
    private Preferences preferences;
    private ConsoleBean consoleBean = new ConsoleBean();
    private JCheckBoxMenuItem consoleMenuItem;
    private boolean closing = false;

    public ConsoleImpl(Workbench workbench, Preferences preferences) {
        this.workbench = workbench;
        this.preferences = preferences;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    @Override
    public ConsoleBean getConsole() {
        return this.consoleBean;
    }

    private void buildGUI() {
        this.consoleBean.setInfoColor(new Color(0, 128, 0));
        ConsoleBeanAction consoleBeanAction = new ConsoleBeanAction();
        this.consoleMenuItem = new JCheckBoxMenuItem(consoleBeanAction);
        this.workbench.getMenuBar().addToApplicationMenu(this.consoleMenuItem);
        try {
            if (this.isConsoleWindowVisible()) {
                consoleBeanAction.showConsoleFrame();
            } else {
                this.consoleMenuItem.setSelected(false);
            }
        }
        catch (BackendException e) {
            String message = this.messages.format("error.preferences", (Object)e.toString());
            this.consoleBean.error(message);
        }
    }

    @Override
    public void close() {
        this.closing = true;
    }

    @Override
    public void initialize() throws Exception {
        this.workbench.addWorkBenchListener(this);
    }

    @Override
    public void start() {
        this.buildGUI();
    }

    private boolean isConsoleWindowVisible() throws BackendException {
        try {
            String state = this.preferences.getString(IS_CONSOLE_WINDOW_VISIBLE);
            return state == null ? false : Boolean.valueOf(state);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
    }

    private void setPreferenceWindowVisible(boolean isVisible) throws BackendException {
        try {
            this.preferences.setString(IS_CONSOLE_WINDOW_VISIBLE, Boolean.toString(isVisible));
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
    }

    private class ConsoleBeanAction
    extends AbstractAction
    implements WorkbenchFrameListener {
        private ImageIcon consoleIcon;

        ConsoleBeanAction() {
            super(ConsoleImpl.this.messages.getMessage("application.console"));
            this.consoleIcon = new ImageIcon(new ConsoleBeanBeanInfo().getIcon(1));
            this.putValue("ShortDescription", ConsoleImpl.this.messages.getMessage("application.console.tooltip"));
            this.putValue("SmallIcon", this.consoleIcon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
            this.putValue("MnemonicKey", new Integer(67));
        }

        @Override
        public void frameClosed(WorkbenchFrame frame) {
            if (!ConsoleImpl.this.closing) {
                ConsoleImpl.this.consoleMenuItem.setSelected(false);
                try {
                    ConsoleImpl.this.setPreferenceWindowVisible(false);
                }
                catch (BackendException exc) {
                    String message = ConsoleImpl.this.messages.format("error.preferences", (Object)exc.toString());
                    ConsoleImpl.this.consoleBean.error(message);
                }
            }
            ConsoleImpl.this.consoleFrame = null;
        }

        @Override
        public void frameWillDispose(WorkbenchFrame frame) {
        }

        private void showConsoleFrame() {
            ConsoleImpl.this.consoleFrame = ConsoleImpl.this.workbench.createWorkbenchFrame(this.getClass().getName(), (JComponent)ConsoleImpl.this.consoleBean, true, true);
            ConsoleImpl.this.consoleFrame.addFrameListener(this);
            ConsoleImpl.this.consoleFrame.setFrameIcon(this.consoleIcon);
            ConsoleImpl.this.consoleFrame.setTitle(ConsoleImpl.this.messages.getMessage("application.console"));
            ConsoleImpl.this.consoleMenuItem.setSelected(true);
            ConsoleImpl.this.consoleFrame.setVisible(true);
            try {
                ConsoleImpl.this.setPreferenceWindowVisible(true);
            }
            catch (BackendException exc) {
                String message = ConsoleImpl.this.messages.format("error.preferences", (Object)exc.toString());
                ConsoleImpl.this.consoleBean.error(message);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ConsoleImpl.this.consoleFrame == null) {
                this.showConsoleFrame();
            } else {
                ConsoleImpl.this.consoleFrame.dispose();
            }
        }
    }
}

