/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.plugin.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.plugin.browser.Browser;
import nu.zoom.swing.text.StatusBarBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

public class BrowserImpl
implements Browser {
    private Log log = LogFactory.getLog(this.getClass());
    private JTextField navField;
    private WorkbenchFrame frame = null;
    private Messages messages;
    private Workbench workbench;
    private JEditorPane pane = null;
    private StatusBarBean statusBar;

    public BrowserImpl(Workbench workbench, Messages messages) {
        this.workbench = workbench;
        this.messages = messages;
    }

    @Override
    public Browser open(URL url) {
        this.log.trace((Object)"Creating a new browser instance");
        BrowserImpl browser = new BrowserImpl(this.workbench, this.messages);
        browser.show(url);
        return browser;
    }

    @Override
    public void show(URL url) {
        this.log.trace((Object)("Trying to display: " + url));
        if (this.frame == null) {
            this.createFrame();
            this.frame.setVisible(true);
        }
        this.frame.moveToFront();
        this.statusBar.setMessage(this.messages.format("browser.statusbar.opening", (Object)url.toString()));
        this.navField.setText(url.toString());
        try {
            this.pane.setPage(url);
            this.statusBar.setMessage("Loaded");
        }
        catch (IOException e) {
            this.log.info((Object)("Unable to display: " + url), (Throwable)e);
            this.statusBar.setMessage(this.messages.getMessage("browser.error"));
            this.workbench.getErrorReporter().reportError(this.messages.getMessage("browser.error"), e);
        }
    }

    @Override
    public void initialize() throws Exception {
    }

    private void createFrame() {
        this.pane = new JEditorPane("text/html", "");
        this.pane.setEditable(false);
        this.navField = new JTextField(80);
        this.statusBar = new StatusBarBean();
        JPanel navigationpanel = new JPanel(new BorderLayout());
        navigationpanel.add((Component)this.navField, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)navigationpanel, "North");
        mainPanel.add((Component)new JScrollPane(this.pane), "Center");
        mainPanel.add((Component)this.statusBar, "South");
        this.frame = this.workbench.createWorkbenchFrame(this.getClass().getName(), mainPanel, true, true);
        this.frame.setTitle(this.messages.getMessage("browser.title"));
        this.pane.addHyperlinkListener(new Hyperactive());
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        BrowserImpl.this.show(e.getURL());
                    }
                    catch (Exception exc) {
                        BrowserImpl.this.workbench.getErrorReporter().reportError(exc);
                    }
                }
            }
        }
    }
}

