/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchMenuBar;
import nu.zoom.swing.desktop.common.action.DetachAction;
import nu.zoom.swing.desktop.common.action.WorkbenchMessageAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

class WorkbenchFramesMenu {
    private Log log = LogFactory.getLog(this.getClass());
    private JMenu windowMenu;
    private HashMap<WorkbenchFrame, JMenu> frameMenues;
    private static String MENU_KEY = "WindowMenu";
    private final Messages messages;

    WorkbenchFramesMenu(Messages messages, WorkbenchMenuBar menuBar) {
        this.messages = messages;
        this.frameMenues = new HashMap();
        this.windowMenu = new JMenu(messages.getMessage("menu.window"));
        this.windowMenu.setMnemonic('w');
        menuBar.addMenu(MENU_KEY, this.windowMenu);
    }

    synchronized void addFrame(WorkbenchFrame frame) {
        this.log.trace((Object)"Trying to add frame to window menu");
        if (frame.getTitle().length() > 0) {
            this.log.trace((Object)"frame title exists - adding frame to menu");
            JMenu frameMenu = this.createFrameMenu(frame);
            this.frameMenues.put(frame, frameMenu);
            this.windowMenu.add(frameMenu);
        }
    }

    synchronized void removeFrame(WorkbenchFrame frame) {
        if (frame != null) {
            this.log.trace((Object)"Removing frame from menu");
            JMenu itemToRemove = this.frameMenues.get(frame);
            if (itemToRemove != null) {
                this.windowMenu.remove(itemToRemove);
            }
            this.frameMenues.remove(frame);
        }
    }

    synchronized void clear() {
        this.log.trace((Object)"Dropping references to all frames");
        this.frameMenues.clear();
        this.windowMenu.removeAll();
    }

    private JMenu createFrameMenu(WorkbenchFrame frame) {
        JMenu frameMenu = new JMenu(frame.getTitle());
        JMenuItem frontItem = new JMenuItem(new FrameToFrontAction(this.messages, frame));
        JMenuItem detachItem = new JMenuItem(new DetachAction(this.messages, frame));
        frameMenu.add(frontItem);
        frameMenu.add(detachItem);
        return frameMenu;
    }

    class FrameToFrontAction
    extends WorkbenchMessageAction {
        private WorkbenchFrame frame;

        FrameToFrontAction(Messages messages, WorkbenchFrame frame) {
            super(messages);
            this.setNameFromMessages("menu.window.tofront");
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.frame.isVisible()) {
                WorkbenchFramesMenu.this.log.trace((Object)"Making frame visible");
                this.frame.setVisible(true);
            }
            WorkbenchFramesMenu.this.log.trace((Object)"Moving frame to front");
            this.frame.moveToFront();
        }
    }
}

