/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.util.ArrayList;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchFrameListener;
import nu.zoom.swing.desktop.WorkbenchMenuBar;
import nu.zoom.swing.desktop.frame.WorkbenchFramesMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

class WorkbenchFrames
implements WorkbenchFrameListener {
    private Log log = LogFactory.getLog(this.getClass());
    private ArrayList<WorkbenchFrame> frames = new ArrayList();
    private boolean closing = false;
    private WorkbenchFramesMenu menuHandler;

    public WorkbenchFrames(Messages messages, WorkbenchMenuBar menuBar) {
        this.menuHandler = new WorkbenchFramesMenu(messages, menuBar);
    }

    synchronized void addFrame(WorkbenchFrame frame) {
        this.log.trace((Object)"Adding frame");
        this.frames.add(frame);
        frame.addFrameListener(this);
        this.menuHandler.addFrame(frame);
    }

    synchronized String getUniqueTitle(String title) {
        boolean titleIsUnique;
        this.log.trace((Object)("Finding unique frame title for title:" + title));
        int titleIndex = 1;
        String compoundTitle = title;
        do {
            titleIsUnique = true;
            for (int f = 0; titleIsUnique && f < this.frames.size(); ++f) {
                this.log.trace((Object)("Checking if title " + compoundTitle + " is unique"));
                String currentTitle = this.frames.get(f).getTitle();
                if (titleIndex < 2) {
                    if (!currentTitle.equals(compoundTitle)) continue;
                    titleIsUnique = false;
                    ++titleIndex;
                    continue;
                }
                compoundTitle = title + " : " + titleIndex;
                if (!currentTitle.equals(compoundTitle)) continue;
                titleIsUnique = false;
                ++titleIndex;
            }
        } while (!titleIsUnique);
        this.log.trace((Object)("Frame title was " + title + " adjusted to " + compoundTitle));
        return compoundTitle;
    }

    synchronized void titleChanged(WorkbenchFrame frame) {
        this.log.trace((Object)"Title changed event");
        this.menuHandler.removeFrame(frame);
        this.menuHandler.addFrame(frame);
    }

    synchronized void closeAll() {
        this.log.trace((Object)"Closing all frames");
        this.closing = true;
        for (int i = 0; i < this.frames.size(); ++i) {
            this.frames.get(i).dispose();
        }
        this.frames.clear();
        this.menuHandler.clear();
    }

    @Override
    public synchronized void frameClosed(WorkbenchFrame frame) {
        if (this.closing) {
            this.log.trace((Object)"Frame closed event due to this class disposing of it");
            return;
        }
        this.log.trace((Object)"Frame closed event, not originating from this class");
        this.frames.remove(frame);
        this.menuHandler.removeFrame(frame);
    }

    @Override
    public void frameWillDispose(WorkbenchFrame frame) {
    }
}

