/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.frame.DetachableWorkbenchFrame;
import nu.zoom.swing.desktop.frame.FrameVisualPreferences;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class WorkbenchFrameDelegate {
    private Log log = LogFactory.getLog(this.getClass());
    protected final DetachableWorkbenchFrame owner;
    protected final Preferences preferences;
    protected final String preferencesKey;
    private final JComponent content;
    private final JMenuBar frameMenu;
    private final boolean resizable;
    private final boolean maximizable;
    private List<ImageIcon> icons = new ArrayList<ImageIcon>();

    public WorkbenchFrameDelegate(DetachableWorkbenchFrame owner, Preferences preferences, String preferencesKey, JComponent content, JMenuBar frameMenu, boolean resizable, boolean maximizable) {
        this.owner = owner;
        this.preferences = preferences;
        this.preferencesKey = preferencesKey;
        this.content = content;
        this.frameMenu = frameMenu;
        this.resizable = resizable;
        this.maximizable = maximizable;
    }

    abstract void dispose();

    abstract String getTitle();

    abstract boolean isVisible();

    abstract void moveToFront();

    void setFrameIcon(List<ImageIcon> icons) {
        this.icons = icons;
        this.delegateSetIcons(icons);
    }

    List<ImageIcon> getFrameIcons() {
        return this.icons;
    }

    abstract void delegateSetIcons(List<ImageIcon> var1);

    abstract void setTitle(String var1);

    abstract void setVisible(boolean var1);

    abstract FrameVisualPreferences getFrameVisualPreferencesFromFrame();

    protected void savePreferences() {
        FrameVisualPreferences prefs = this.getFrameVisualPreferencesFromFrame();
        if (prefs != null) {
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Trying to store disposing frame position and size to preferences using key: " + this.preferencesKey));
                }
                this.preferences.setInteger(this.preferencesKey + ".width", prefs.getWidth());
                this.preferences.setInteger(this.preferencesKey + ".height", prefs.getHeight());
                this.preferences.setInteger(this.preferencesKey + ".x", prefs.getPositionx());
                this.preferences.setInteger(this.preferencesKey + ".y", prefs.getPositiony());
            }
            catch (BackendException e) {
                this.log.warn((Object)"Unable to store preferences", (Throwable)e);
            }
        }
    }

    protected FrameVisualPreferences getFrameVisualPreferencesFromPreferences() {
        try {
            Integer width = this.preferences.getInteger(this.preferencesKey + ".width");
            Integer height = this.preferences.getInteger(this.preferencesKey + ".height");
            Integer x = this.preferences.getInteger(this.preferencesKey + ".x");
            Integer y = this.preferences.getInteger(this.preferencesKey + ".y");
            return new FrameVisualPreferences(width, height, x, y);
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to retrieve frame visual preferences", (Throwable)e);
            return null;
        }
    }

    JComponent getContent() {
        return this.content;
    }

    JMenuBar getFrameMenu() {
        return this.frameMenu;
    }

    public synchronized boolean isMaximizable() {
        return this.maximizable;
    }

    public synchronized boolean isResizable() {
        return this.resizable;
    }

    abstract void savePreferencesAndDisposeOfNativeFrameWithoutCallbacks();
}

